
/*
 * Michael V. Antosha
 * 2020
 * m.antosha@samsung.com
 */

#include <iostream>
using std::endl;

#include <vector>
using std::vector;

#include <utility>
using std::pair;
using std::make_pair;

#include <set>
using std::set;

#include <algorithm>
using std::sort;

#include <string>
using std::string;

// #include <random>

#ifdef MIVAEL_DEBUG
namespace
{
    using std::clog;
}
#endif

namespace
{
    typedef long long intll;

    // inline intll randInt(const intll mn, const intll mx)
    // {
    //     // static std::default_random_engine generator(1029355);  // seed
    //     // static std::default_random_engine generator(1029356);  // seed
    //     // static std::default_random_engine generator(1029357);  // seed
    //     static std::default_random_engine generator(1029358);  // seed

    //     std::uniform_int_distribution<intll> distribution(mn, mx);
    //     return distribution(generator);
    // }
}

int main()
{
    using std::cin;
    using std::cout;
    std::ios_base::sync_with_stdio(false);  cin.tie(0);

#ifdef MIVAEL_TESTING
    // const intll MaxM = intll(1e16) - 1;
    const intll MaxM = intll(1e2) - 1;
    clog << "MaxM = " << MaxM << "." << endl;

    static intll digFreq[10];
    static intll dig1Freq[10];
    for (int dig = 0;  dig < 10;  ++dig)  digFreq[dig] = 0;
    for (int dig = 0;  dig < 10;  ++dig)  dig1Freq[dig] = 0;

    for (int cnt = 0;  cnt < int(1e4);  ++cnt)
    {
        // clog << "\t""cnt = " << cnt << "." << endl;

        const intll mm = randInt(1, MaxM);
        const intll nn = randInt(1, mm);
        // clog << "\t\t""M = " << mm << ",  N = " << nn << "." << endl;

        {
            intll nrest = nn;
            int cntDigs = 0;
            while (nrest > 0)
            {
                ++cntDigs;

                const int dig = nrest % 10;
                nrest /= 10;

                ++digFreq[dig];

                if (nrest == 0)  ++dig1Freq[dig];
            }
        }
    }

    for (int dig = 0;  dig < 10;  ++dig)
    {
        clog << "digFreq[" << dig << "] = " << digFreq[dig]
             << "   dig1Freq[" << dig << "] = " << dig1Freq[dig] << "." << endl;
    }
    return 0;
#endif  // MIVAEL_TESTING

    int T;  cin >> T;
    for (int tc = 1;  tc <= T;  ++tc)
    {
        int U;  cin >> U;

        static intll echarFreq[26];
        static intll otherCharFreq[26];
        for (int chi = 0;  chi < 26;  ++chi)  echarFreq[chi] = 0;
        for (int chi = 0;  chi < 26;  ++chi)  otherCharFreq[chi] = 0;

        for (int cnt = 0;  cnt < int(1e4);  ++cnt)
        {
            intll Q;  string R;  cin >> Q >> R;

            ++echarFreq[ int(R[0]) - int('A') ];

            for (int pos = 1;  pos < int(R.size());  ++pos)
            {
                ++otherCharFreq[ int(R[pos]) - int('A') ];
            }
        }

        vector< pair<intll,int> > freqChiPairs;
        set<int> eldestChis;
        for (int chi = 0;  chi < 26;  ++chi)
        {
            freqChiPairs.push_back(make_pair(echarFreq[chi], chi));

            if (echarFreq[chi] > 0)  eldestChis.insert(chi);
        }

        string D(10, '_');

        for (int chi = 0;  chi < 26;  ++chi)
        {
            if (otherCharFreq[chi] > 0)
            {
                if (eldestChis.find(chi) == eldestChis.end())  D[0] = char(chi + int('A'));
            }
        }

        sort(freqChiPairs.begin(), freqChiPairs.end());

        {
            char dig = 9;
            for (const auto& freqChi : freqChiPairs)
            {
                if (freqChi.first > 0)  D[dig--] = char(freqChi.second + int('A'));
            }
        }

        cout << "Case #" << tc << ": ";
        cout << D << "\n";
    }
    return 0;
}
