# include <iostream>
# include <cmath>
# include <algorithm>
# include <stdio.h>
# include <cstdint>
# include <cstring>
# include <string>
# include <cstdlib>
# include <vector>
# include <bitset>
# include <map>
# include <queue>
# include <ctime>
# include <stack>
# include <set>
# include <list>
# include <random>
# include <deque>
# include <functional>
# include <iomanip>
# include <sstream>
# include <fstream>
# include <complex>
# include <numeric>
# include <immintrin.h>
# include <cassert>
# include <array>
# include <tuple>
# include <unordered_map>
# include <unordered_set>
# include <thread>

using namespace std;

using ll = long long;
using ull = unsigned long long;
using ld = long double;
using ui32 = unsigned int;
constexpr ll INFLL = 1e18;

#define CHECK_IMPL1(cond)              \
if (!(cond)) {                         \
    DEBUG("expected cond: " << #cond); \
    assert(cond);                      \
}

#define CHECK_IMPL2(cond, message)                                            \
if (!(cond)) {                                                                \
    DEBUG("expected cond: " << #cond << " failed with message: " << message); \
    assert(cond);                                                             \
}
#define CHECK_IMPL(_1, _2, NAME, ...) NAME
#define CHECK(...) CHECK_IMPL(__VA_ARGS__, CHECK_IMPL2, CHECK_IMPL1, CHECK_IMPL0)(__VA_ARGS__)

#ifdef __APPLE__
#define DEBUG(message) std::cerr << message << std::endl;
#else
#define DEBUG(message)
#endif

int number_len(ll x, int& last) {
  int res = 0;
  while (x > 0) {
    ++res;
    last = x % 10;
    x /= 10;
  }
  return res;
}

ll get_u(int u) {
  if (u == 2) {
    return 100;
  } else {
    return 1000ll * 1000 * 1000 * 1000ll * 1000l * 10;
  }
}

void solve() {
  int u;
  cin >> u;

  std::random_device rd;
  std::mt19937 gen(rd());
  std::uniform_int_distribution<ll> distribution(1, get_u(u) - 1);

  int n = 10000;

  vector<char> res(10, 0);

  set<char> seen;
  set<char> used;

  map<char, int> count;
  vector<pair<int, char>> pairs;

  for (int i = 0; i < n; i++) {
    ll m;
    string s;
    cin >> m >> s;

//    m = distribution(gen);

    for (auto ch : s) {
      seen.insert(ch);
    }
//    int main_digit = -1;
//    int m_len = number_len(m, main_digit);
    if (s.size() == u) {
      count[s[0]] += 1;
    }
  }

  for (auto it : count) {
    pairs.push_back({ it.second, it.first });
  }

  sort(pairs.begin(), pairs.end());

  for (int i = 9, j = 0; i >= 1; i--, j++) {
    CHECK(j < pairs.size());
    res[i] = pairs[j].second;
    used.insert(res[i]);
  }

  for (auto ch : seen) {
    if (used.find(ch) == used.end()) {
      res[0] = ch;
      break;
    }
  }
  for (int i = 0; i < 10; i++) {
    cout << res[i];
  }
  cout << "\n";
}

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(0);
#ifdef __APPLE__
  freopen("input.txt", "r", stdin);
  // freopen("output.txt", "w", stdout);
#endif
  int t = 1;
  cin >> t;
  for (int i = 1; i <= t; i++) {
    cout << "Case #" << i << ": ";
    solve();
  }
  return 0;
}
