#include <cassert>
#include <iostream>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <vector>

using namespace std;

bool isPairUseful(string &maximum_string, long long maximum, string number) {
  if (maximum < 0) {
    return false;
  }

  maximum_string = to_string(maximum);
  return number.length() == maximum_string.length();
}

void calculate() {
  unsigned short remaining = 10000;
  unordered_map<char, char> charMap;
  unordered_map<char, char> numMap;
  unordered_set<char> charSet;

  bool smaller[26] = {true};

  while (remaining--) {
    int Q;
    string R;
    cin >> Q >> R;

    string Q_str;
    for (auto e : R) {
      charSet.insert(e);
    }
    if (!isPairUseful(Q_str, Q, R)) {
      continue;
    }

    assert(Q_str.length() == R.length());
    if (charMap.find(R[0]) == charMap.end()) {
      charMap[R[0]] = Q_str[0] - '0';
    } else {
      charMap[R[0]] = min(charMap[R[0]], static_cast<char>(Q_str[0] - '0'));
    }
    numMap[charMap[R[0]]] = R[0];
  }

  for (auto e : charSet) {
    if (charMap.find(e) == charMap.end()) {
      cout << e;
      break;
    }
  }
  for (int i = 1; i < 10; i++) {
    cout << numMap[i];
  }
}

int main() {
  int T;
  cin >> T;
  int U;
  cin >> U;

  for (int i = 1; i <= T; i++) {
    cout << "Case #" << i << ": ";
    calculate();
    cout << endl;
  }
}