#include <iostream>
#include <vector>
#include <set>
#include <string>
#include <algorithm>

#define MAX 300
#define ILE_ZAPYTAN 10000

using namespace std;
typedef vector<int> VI;

class Lancuch
{
private:
	VI odkad;
	VI dokad;
	int ileCyfr;
	set<char> litery;
public:
	Lancuch(int U) : ileCyfr(U), odkad(MAX, 0), dokad(MAX,9)
	{
	}
	void aktualizuj(int Q, string R)
	{
		int dlugoscR = R.size();
		int dlugoscQ = 1;

		char firstZn = R[0];
		int firstDig = Q;
		while (firstDig > 9)
		{
			++dlugoscQ;
			firstDig /= 10;
		}

		if (dlugoscR == dlugoscQ)
		{
			odkad[firstZn] = max(odkad[firstZn], 1);
			dokad[firstZn] = min(dokad[firstZn], firstDig);
		}
		else //dlugoscR < dlugoscQ
		{
			odkad[firstZn] = max(odkad[firstZn], 1);
			dokad[firstZn] = min(dokad[firstZn], 9);
		}

		for (int i = 0; i < R.size(); ++i) litery.insert(R[i]);
	}
	string solve()
	{
		string D(10,' ');

		for (int cyfra = 1; cyfra < 10; ++cyfra)
		{
			bool found = false;
			for (auto IT = litery.begin(); IT != litery.end(); ++IT)
			{
				char zn = *IT;
				if (odkad[zn] == cyfra && dokad[zn] == cyfra)
				{
					D[cyfra] = zn;
					litery.erase(zn);
					found = true;
					break;
				}
			}
			if (!found)
			{
				for (auto IT = litery.begin(); IT != litery.end(); ++IT)
				{
					char zn = *IT;
					if (odkad[zn] == cyfra)
					{
						D[cyfra] = zn;
						litery.erase(zn);
						found = true;
						break;
					}
				}
			}
				
			for (auto IT = litery.begin(); IT != litery.end(); ++IT)
			{
				char zn = *IT;
				if (odkad[zn] == cyfra) ++odkad[zn];
			}
		}
		//Jeszcze zero
		char zeroZn = *litery.begin();
		D[0] = zeroZn;

		return D;
	}

};

int main()
{
	ios::sync_with_stdio(0);

	int T; cin >> T;
	for (int test = 1; test <= T; ++test)
	{
		int U; cin >> U;
		Lancuch L(U);
		for (int i = 1; i <= ILE_ZAPYTAN; ++i)
		{
			int Q; string R;
			cin >> Q >> R;
			L.aktualizuj(Q, R);
		}
		string D = L.solve();
		cout << "Case #" << test << ": " << D << endl;
	}

	return 0;
}