/*
veniveni Reuven Yakar - 2.5.20
*/

#include <iostream>
#include <string>
#include <vector>
#include <cmath>
#include <algorithm>
#include <map>
#include <set>

using namespace std;

string decode(vector<pair<long long,string>>& records) {
	string result = "----------";
	vector<char> letters;
	map<char, set<int>> options;
	while (result.find('-') != string::npos) {
		for (auto r : records) {
			if (options.size() < 10) {
				for (char c : r.second) {
					if (options.find(c) == options.end()) {
						options[c] = {0,1,2,3,4,5,6,7,8,9};
						letters.push_back(c);
					}
				}
			}
			
			long long len = (long long)(log(r.first)/log(10)) + 1;
			
			if (r.second.size() != len) continue;
			char c = r.second[0];
			if (result.find(c) != string::npos) continue;
			long long p = (long long)pow(10, len-1);

			int max_d = r.first / p;
			bool new_finding = false;
			if (options[c].find(0) != options[c].end()) {
				new_finding = true;
				options[c].erase(0);
			}
			if (max_d < 9) new_finding = true;
			for (int i = max_d + 1; i < 10; i++) {
				options[c].erase(i);
			}
			while (new_finding) {
				new_finding = false;
				for (char c : letters) {
					if (options[c].size() == 1 && result[*options[c].begin()] == '-') {
						new_finding = true;
						result[*options[c].begin()] = c;

						for (char cc : letters) {
							if (options[cc].size() != 1) {
								options[cc].erase(c);
							}
						}
					}
				}
				for (int i = 0; i < 10; i++) {
					int count = 0;
					char cc = 0;
					if (result[i] != '-') continue;
					for (char c : letters) {
						if (options[c].find(i) != options[c].end()) {
							count++;
							cc = c;
						}
					}
					if (count == 1) {
						new_finding = true;
						for (int j = 0; j < 10; j++) {
							if (j != i)
								options[cc].erase(i);
						}
						result[i] = cc;
					}
				}
			}
			if (result.find('-') == string::npos) break;
		}
		cout << result << '\r';
	}
	return result;
}

int main() {
	int T,U;
	long long Q;
	string s;
	cin >> T;
	cin >> U;
	vector<pair<long long, string>> records(10000);
	for (int i = 1; i <= T; i++) {
		for (int j = 0; j < 10000; j++){
			cin >> Q >> s;
			records[j] = {Q,s};
		}
		if (Q == -1) {
			cout << "Case #" << i << ": " << "Unsupported" << endl;
			break;
		}
		cout << "Case #" << i << ": " << decode(records) << endl;
	}
	return 0;
}
