#include <cassert>
#include <algorithm>
#include <iostream>
#include <vector>
#include <map>
#include <set>

using namespace std;

int main() {
    int t;
    cin >> t;

    for (int z = 1; z <= t; z++) {
        int u;
        cin >> u;

        map<char, int> freqs;
        set<char> could_be_zero;
        
        for (int i = 0; i < 10000; i++) {
            long long q;
            string r;
            cin >> q >> r;

            freqs[r[0]]++;
            for (char c : r)
              could_be_zero.insert(c);
        }

        for (auto p : freqs)
          could_be_zero.erase(p.first);

        vector<pair<int, char>> v;
        for (auto p : freqs)
            v.emplace_back(p.second, p.first);
        // Benford!
        sort(v.rbegin(), v.rend());

        assert(could_be_zero.size() == 1);
        string ans = string(1, *could_be_zero.begin());
        for (int i = 0; i < v.size(); i++)
            ans += v[i].second;

        cout << "Case #" << z << ": " << ans << endl;
                
    }
}
