#include<bits/stdc++.h>
using namespace std;

using namespace std;
string to_string(string s) {
  return '"' + s + '"';
}

string to_string(const char* s) {
  return to_string((string) s);
}

string to_string(bool b) {
  return (b ? "true" : "false");
}

template <typename A, typename B>
string to_string(pair<A, B> p) {
  return "(" + to_string(p.first) + ", " + to_string(p.second) + ")";
}

template <typename A>
string to_string(A v) {
  bool first = true;
  string res = "{";
  for (const auto &x : v) {
    if (!first) {
      res += ", ";
    }
    first = false;
    res += to_string(x);
  }
  res += "}";
  return res;
}

void debug_out() { cerr << endl; }
template <typename Head, typename... Tail>
void debug_out(Head H, Tail... T) {
  cerr << " " << to_string(H);
  debug_out(T...);
}

//#define LOCAL

#ifdef LOCAL
#define debug(...) cerr << "[" << #__VA_ARGS__ << "]:", debug_out(__VA_ARGS__)
#else
#define debug(...) 42
#endif

int main() {
	ios_base::sync_with_stdio(false), cin.tie(nullptr), cout.tie(nullptr);
	int T; cin >> T;

	for (int case_num = 1; case_num <= T; case_num ++) {
        int u;
        cin >> u;
        map<char, int> count;
        set<char> leading;
        set<char> total;
        for (int i = 0; i < 10000; i++) {
            long long q;
            string r;
            cin >> q >> r;
            for (int j = 0; j < r.size(); j++) {
                if (j == 0) {
                    leading.insert(r[j]);
                    ++count[r[j]];
                }
                total.insert(r[j]);
            }
        }
        vector<pair<int, char>> vec;
        for (const auto& kv : count) {
            vec.emplace_back(kv.second, kv.first);
        }
        sort(vec.begin(), vec.end());
        string result(10, 'x');
        int p = 9;
        for (const auto& item : vec) {
            result[p--] = item.second;
        }
        for (auto& ch : total) {
            if (leading.find(ch) == leading.end()) {
                result[0] = ch;
                continue;
             }
        }
        cout << "Case #" << case_num << ": " << result << endl;
    }
    return 0;
}