#include <iostream>
#include <vector>
#include <unordered_map>
#include <map>
#include <queue>
#include <stack>
#include <string>
#include <functional>
#include <algorithm>
#include <math.h>
#include <random>
#include <limits>
#include <bitset>
#include <iomanip>
#include <set>
#include <utility>
#include <climits>
#include <chrono>
#include <unordered_set>

using namespace std;
typedef unsigned long long ull;
typedef long long ll;
typedef pair<int, int> pii;
typedef pair<ll, ll> pll;

struct Query{
    ll query_upp_bound;
    string query_rez;
    bool operator< (const Query & x) const {
        return query_upp_bound < x.query_upp_bound;
    }
};

string solve(){
    int num_digs; cin >> num_digs;
    vector<Query> v;
    map<int, set<char>> possible_hash;
    set<char> universe;
    for (ll i = 0; i < 1e4; i++){
        ll upp_bound; cin >> upp_bound;
        string rez; cin >> rez;
        v.push_back({upp_bound, rez});
        for (auto &x: rez) universe.insert(x);
    }

    for (ll i = 0; i <= 9; i++){
        possible_hash[i] = universe;
    }
    sort(v.begin(), v.end());
    for (auto &x: v){
        string rez = x.query_rez;
        if (possible_hash[0].count(rez[0])) possible_hash[0].erase(rez[0]);
    }
    set<char> used;
    vector<char> ans(10, 0);
    ans[0] = *(possible_hash[0].begin());
    used.insert(ans[0]);
    map<char, ll> first_dig;
    for (auto &x: v) {
        ll up = x.query_upp_bound;
        string rez = x.query_rez;
        if (rez.size() != num_digs) continue;
        first_dig[rez[0]]++;
    }
    vector<pair<ll, char>> guh;
    for (auto &x: first_dig){
        int num = x.second;
        char chare = x.first;

        guh.push_back({num, chare});
    }
    sort(guh.begin(), guh.end());
    reverse(guh.begin(), guh.end());
    for (int i = 1; i <= 9; i++){
        ans[i] = guh[i - 1].second;
    }
    string anse;
    for (ll i = 0; i <= 9; i++){
        anse += ans[i];
    }
    return anse;

}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t; cin >> t;
    for (int z = 1; z <= t; z++){
        cout << "Case #" << z << ": " << solve() << '\n';
    }
}