#include <iostream>
#include <vector>
#include <queue>
#include <cmath>
#include <algorithm>

using namespace std;

struct data {
    int U;
    vector<string> Q;
    vector<string> R;
};

struct solution {
    int i; // case number
    string D;
};

char getChar(const vector<bool>& row) {
    return std::distance(row.begin(), std::find(row.begin(), row.end(), true)) + 'A';
}

solution solve(const data& data) {
    solution soln;
    vector<bool> not_seen(29, true);
    vector<vector<bool>> map(10, vector<bool>(29, true));


    int count = 0;
    for (int i = 0; i < 10000; ++i) {
        int first_R = data.R[i][0]-'A';
        map[0][first_R] = false; // cant be 0
        if (data.Q[i].size() == data.R[i].size()) {
            int first_Q = data.Q[i][0]-'0';
            for (int j = first_Q+1; j <= 9; ++j) {
                count++;
                map[j][first_R] = false;
            }
        }
        for (char c : data.R[i]) {
            not_seen[c-'A'] = false;
        }
    }

    for (auto& row : map) {
        for (int i = 0; i < 29; ++i) {
            if (not_seen[i]) {
                row[i] = false;
            }
        }
    }

    char zero_char = getChar(map[0]);
    string D{};
    for (int i = 9; i >= 1; --i) {
        map[i][zero_char-'A'] = false;
        for (char c : D) {
            map[i][c-'A'] = false;
        }
        D = getChar(map[i]) + D;
    }

    D = zero_char + D;
    soln.D = D;
    return soln;
}

data read_data() {
    data data{};
    cin >> data.U;
    data.Q.resize(10000);
    data.R.resize(10000);
    for (int i = 0; i < 10000; ++i) {
        cin >> data.Q[i];
        cin >> data.R[i];
    }
    return data;
}

void write_solution(const solution& soln) {
    cout << "Case #" << soln.i << ": ";
    cout << soln.D;
    cout << endl;
}

int main() {
    int T;
    cin >> T;
    for (int i = 0; i < T; ++i) {
        data data = read_data();
        solution soln = solve(data);
        soln.i = i+1;
        write_solution(soln);
    }
    return 0;
}
