#include <iostream>
#include <algorithm>
#include <vector>
#include <string>
#include <stdio.h>

#define N 10000

int U;
typedef std::pair<std::string, std::string> Pair;
std::vector<Pair> pairs;

std::string chars;
int table[256];
bool used_num[10];
std::string result;

uint64_t Trans(const std::string &str) {
    uint64_t value = 0;
    for (int i = 0; i < str.size(); ++i) {
        value *= 10;
        value += table[str[i]];
    }
    return value;
}

bool TestOK() {
    for (int i = 0; i < N; ++i) {
        uint64_t m = std::stoull(pairs[i].first);
        uint64_t value = Trans(pairs[i].second);
        if (value > m || value == 0) {
            return false;
        }
    }
    return true;
}

bool TestFastOK(int a, char ch) {
    for (int i = 0; i < N; ++i) {
        if (pairs[i].first.size() == pairs[i].second.size() &&
            pairs[i].second[0] == ch && a > pairs[i].first[0] - '0') {
            return false;
        }
    }
    return true;
}

bool Search(int n) {
    if (n == chars.size()) {
        if (TestOK()) {
            result.resize(chars.size());
            for (int i = 0; i < chars.size(); ++i) {
                result[table[chars[i]]] = chars[i];
            }
            return true;
        }
        return false;
    }
    for (int i = 0; i < 10; ++i) {
        if (!used_num[i] && TestFastOK(i, chars[n])) {
            used_num[i] = true;
            table[chars[n]] = i;
            bool find = Search(n + 1);
            used_num[i] = false;
            if (find) {
                return true;
            }
        }
    }
    return false;
}

void RunTest() {
    std::cin >> U;
    pairs.resize(N);
    chars.clear();
    for (int i = 0; i < 10; ++i) {
        used_num[i] = false;
    }
    for (int i = 0; i < N; ++i) {
        std::cin >> pairs[i].first >> pairs[i].second;
        for (int j = 0; j < pairs[i].second.size(); ++j) {
            char ch = pairs[i].second[j];
            if (chars.find(ch) == std::string::npos) {
                chars += ch;
            }
        }
    }
    if (!Search(0)) {
        result.clear();
    }
    while (result.size() < 10) {
        for (int i = 0; i < 26; ++i) {
            if (result.find('A' + i) == std::string::npos) {
                result += ('A' + i);
                break;
            }
        }
    }
    std::cout << result << std::endl;
}

int main() {
    int T;
    scanf("%d", &T);
    for (size_t case_no = 1; case_no <= T; ++case_no) {
        printf("Case #%d: ", case_no);
        RunTest();
    }
    return 0;
}
