#include <iostream>
#include <vector>
#include <algorithm>
#include <map>

struct KVP {
	char label;
	int num;
	KVP(char nl, int nn) {label = nl; num = nn; }
};

bool compareKVP(const KVP &a, const KVP &b) {return (a.num > b.num); }

struct Problem {
	char solution[11];
	std::map<char, int> frequenciesFirstDigit;
	std::vector<char> allDigits;
	std::vector<KVP> sortedVals;
	void solve() {
		int dummy; std::cin >> dummy;
		for(int i=0;i<10000;i++) {
			std::string word;
			std::cin >> dummy >> word;
			char firstChar = word[0];
			for(int j=0;j<word.length();j++) allDigits.push_back(word[j]);
			if(frequenciesFirstDigit.find(firstChar) == frequenciesFirstDigit.end()) 
				frequenciesFirstDigit[firstChar] = 1;
			else
				frequenciesFirstDigit[firstChar] = frequenciesFirstDigit[firstChar] + 1;
		}	
		// Sort
		for(std::map<char, int>::iterator it = frequenciesFirstDigit.begin(); it != frequenciesFirstDigit.end(); it++) {
			sortedVals.push_back(KVP(it->first, it->second));
		}
		std::sort(sortedVals.begin(), sortedVals.end(), compareKVP);
		for(int i=0;i<sortedVals.size();i++) solution[i+1] = sortedVals[i].label;
		for(int i=0;i<allDigits.size();i++) {
			if(frequenciesFirstDigit.find(allDigits[i]) == frequenciesFirstDigit.end()) {
				solution[0] = allDigits[i];
				break;
			}
		}
		solution[10] = '\0';
	}
};

int main(void) {
	int cases; std::cin >> cases;
	for (int i=0;i<cases;i++) {
		Problem newProblem;
		newProblem.solve();
		std::cout << "Case #" << i << ": " << newProblem.solution << "\n";
	}
}


