#include <iostream>
#include <vector>
#include <map>
#include <bitset>

int main() {
    int T;
    std::cin >> T;


    for (auto t = 0; t < T; ++t)
    {
        int U;
        std::cin >> U;

        std::map<char, std::bitset<10>> data;
        int64_t number;
        std::string randomStr;
        std::vector<char> result(10, 0);
        std::map<char, bool> foundChar;

        auto updateNumber = [&](char ch, int start, int end)
        {
            auto dataIter = data.find(ch);
            if (dataIter == data.end())
            {
                std::bitset<10> range;
                for (auto i = start; i <= end; i++)
                    range[i] = true;

                data[ch] = range;
            } else {
                if (foundChar.find(ch) != foundChar.end())
                    return;
                auto range = data[ch];
                for (auto i = 0; i <= 9; i++)
                    if (range[i] && (i < start || i > end))
                        range[i].flip();
                if (range.count() == 0)
                    return;
                data[ch] = range;
            }
        };

        std::vector<std::pair<int64_t, std::string>> input;

        for (auto c = 0; c < 10000; ++c)
        {
            std::cin >> number;
            std::cin >> randomStr;

            input.push_back({number, randomStr});
        }

        while (true)
        {
            for (auto& val : input)
            {
                number = val.first;
                randomStr = val.second;

                if (number < 0)
                {
                    updateNumber(randomStr[0], 1, 9);
                    for (auto i = 1; i < randomStr.size(); ++i)
                        updateNumber(randomStr[i], 0, 9);
                }
                else if (number < 10)
                {
                    updateNumber(randomStr[0], 0, number);
                } else {
                    auto numberStr = std::to_string(number);
                    if (numberStr.size() == randomStr.size())
                    {
                        updateNumber(randomStr[0], 1, numberStr[0] - '0');
                        /*for (auto i = 1; i < randomStr.size(); ++i)
                            updateNumber(randomStr[i], 0, 9);*/

                        int remain = 0;
                        for (auto i = 0; i < randomStr.size(); ++i)
                        {
                            if (foundChar.find(randomStr[i]) != foundChar.end() && result[numberStr[i] - '0'] == randomStr[i])
                            {
                                continue;
                            } else {
                                updateNumber(randomStr[i], 0, numberStr[i] - '0');
                                remain = i;
                                break;
                            }
                        }
                        for (;remain < randomStr.size(); ++remain)
                            updateNumber(randomStr[remain], 0, 9);
                    } else {
                        updateNumber(randomStr[0], 1, 9);
                        for (auto i = 1; i < randomStr.size(); ++i)
                            updateNumber(randomStr[i], 0, 9);
                    }
                }
            }

            for (auto& item : data)
            {
                auto range = item.second;
                for (auto i = 0; i < 10; i++)
                    if (result[i] > 0)
                        range[i] = false;
                if (range.count() == 1)
                    for (auto i = 0; i < 10; i++)
                        if (range[i])
                        {
                            foundChar[item.first] = true;
                            result[i] = item.first;
                            break;
                        }
            }

            bool notyet = false;
            for (auto i = 0; i < result.size(); ++i)
                if (result[i] == 0)
                    notyet = true;

            if (!notyet)
                break;

            /*for (auto i = 0; i < result.size(); ++i)
                std::cout << (result[i] == 0 ? '0' : result[i]) << " ";

            std::cout << std::endl;
            for (auto& elem : data)
            {
                std::cout << elem.first << ": " << elem.second << std::endl;
            }
            getchar();*/
        }

        /*for (auto i = 0; i < result.size(); ++i)
            std::cout << (result[i] == 0 ? '0' : result[i]) << " ";

        std::cout << std::endl;
        for (auto& elem : data)
        {
            std::cout << elem.first << ": " << elem.second.first << " - " << elem.second.second << std::endl;
        }*/

        std::cout << "Case #" << (t+1) << ": ";//<< std::endl;
        for (auto i = 0; i < result.size(); ++i)
            std::cout << result[i];
        std::cout << std::endl;
    }

    return 0;
}
