#include <iostream>
#include <sstream>
#include <string>
#include <cstring>
#include <list>
#include <vector>
#include <set>
#include <algorithm>

using namespace std;
const string possible = "POSSIBLE";
const string impossible = "IM" + possible;
const double pi = 3.1415926535;
const string whitespace = " \t\r\n";

#ifdef PFTEST
template<typename T>
void dbg(ostream& os, const T& x)
{
    os << x;
}
template<typename T, typename ... Args>
void dbg(ostream& os, const T& x, Args... args)
{
    os << x;
    dbg(os, args...);
}
#else
#define dbg(...)
#endif

using P = vector<set<char>>;

void dump(const P& p)
{
    for(unsigned i = 0; i < p.size(); ++i)
        for(auto c: p[i])
            cout << c;
}

void erase(P& p, unsigned k, char c)
{
    for(unsigned i = 0; i < p.size(); ++i)
    {
        auto &s = p[i];
        if((i != k) && (s.end() != s.find(c)))
        {
            s.erase(c);
            if(s.size() == 1)
                erase(p, i, *s.begin());
        }
    }
}

void solve_case(int case_number)
{
    cout << "Case #" << case_number << ": ";

    int U;
    cin >> U;

    struct Input {
        string Q;
        string R;
    };

    set<char> D;

    vector<Input> v(10000);
    for(auto& i: v)
        cin >> i.Q >> i.R;

    for(auto i: v)
        for(auto c: i.R)
            if(D.end() == D.find(c))
                D.insert(c);

    P p(10, D);

    for(auto& i: v)
    {
        char c = i.Q[0];
        if(c == '-')
            continue;
        if(i.Q.size() == i.R.size())
        {
            char r = i.R[0];
            int digit = c - '0';
            for(int i = digit + 1; i < 10; ++i)
                p[i].erase(r);
            if(i.Q.size() == 1)
                p[0].erase(i.R[0]);
        }
    }

    for(unsigned i = 0; i < p.size(); ++i)
    {
        if(p[i].size() == 1)
        {
            erase(p, i, *p[i].begin());
        }
    }

    dump(p);

    /*
    for(char c: p.back())
    {
        for(auto &i: v)
        {
            if(i.R[0] == c)
        }
    }
    */
}

int main()
{
    int t;

    cin >> t;

    for(int c = 1; c <= t; ++c) {
        solve_case(c);
        cout.flush();
    }
}

