#include <bits/stdc++.h>

char findZero(const std::vector<std::string>& outputs)
{
  std::vector<bool> canBeZero(256, true);
  std::vector<bool> seen(256, false);

  for (const auto& out : outputs)
  {
    for (char c : out)
      seen[c] = true;

    if (out.size() <= 1)
      continue;

    canBeZero[out[0]] = false;
  }

  for (char c='A'; c<='Z'; c++)
  {
    if (seen[c] && canBeZero[c])
      return c;
  }

  assert(0);
}

std::string frequencies(const std::vector<std::string>& outputs)
{
  std::vector<std::pair<long, char>> freq(256, std::pair<long, char>(0, 0));

  for (char c='A'; c<='Z'; c++)
    freq[c].second = c;

  for (const auto& out : outputs)
  {
    for (char c : out)
      if (freq[c].first != 1)
        freq[c].first = 1;
  }

  for (const auto& out : outputs)
  {
    freq[out[0]].first++;
  }

  std::sort(freq.begin(), freq.end());
  std::reverse(freq.begin(), freq.end());
  std::string order;
  for (long i=0; i<10; i++)
    order.push_back(freq[i].second);

  return order;
}

int main() {
  long T;
  std::cin >> T;
  for (long t=1; t<=T; t++)
  {
    long U;
    std::cin >> U;

    std::vector<std::string> outputs;
    for (long i=0; i<10000; i++)
    {
      long x;
      std::cin >> x;

      std::string line;
      std::cin >> line;

      outputs.push_back(line);
    }

    char zero = findZero(outputs);
    std::string order = frequencies(outputs);

    order.erase(std::remove(order.begin(), order.end(), zero), order.end());

    std::cout << "Case #" << t << ": " << zero + order << std::endl;
  }

  return 0;
}
