#ifndef LOCAL_RUN
#pragma GCC optimize("O3")
#endif
#include <iostream>
#include <vector>
#include <cstring>
#include <map>
#include <set>
#include <cmath>

using namespace std;

bool debugging_enabled = false;

#define ll long long
#define ull unsigned long long
#define pii pair<int, int>
#define pll pair<ll, ll>
#define vi vector<int>
#define vll vector<ll>
#ifdef LOCAL_RUN
#define debug(x) do { if (debugging_enabled) std::cerr << #x << ": " << x << std::endl; } while (0)
#else
#define debug(x) do {} while (0)
#endif

struct DebugRAII
{
	DebugRAII()
	{
		debugging_enabled = true;
	}
	~DebugRAII()
	{
		debugging_enabled = false;
	}
};

const char* impossible = "IMPOSSIBLE";

template <class T>
std::ostream& operator<<(std::ostream& os, const vector<T> &input)
{
	os << '[';
	for(size_t i = 0; i < input.size(); i++)
	{
		os << input[i] << ((i!=input.size()-1) ? " " : "");
	}
	os << ']';
	return os;
}

template <class A, class B>
std::ostream& operator<<(std::ostream& os, const pair<A, B> &input)
{
	return os << '(' << input.first << ", " << input.second << ")";
}

struct TestCase
{
	int idx;
	TestCase(int idx):idx(idx){}

	//Input data
	int U;
	vector<pair<int, string>> requests;

	void Input()
	{
		int requests_count = 10 * 10 * 10 * 10;
		
		char c[17];
		int m;
		cin >> U;

		for(size_t i = 0; i < requests_count; i++) {
			cin >> m >> c;
			requests.push_back({m,c});
		}
	}

	bool known_below(const set<int>& fd, int digit)
	{
		for(int i = 1; i < digit; i++)
		{
			if(fd.find(i) == fd.end())
				return false;
		}

		return true;
	}

	void Solve()
	{
		map<char, int> letters;
		set<char> first_letters;
		set<char> all_letters;
		set<int> found_digits;
		bool moved = false;
		do
		{
			for(auto& r : requests)
			{
				char first = r.second[0];
				int m = r.first;

				auto it = letters.find(first);
				if (it != letters.end() && it->second != -1)
				{
					continue;
				}

				if(r.first == 1)
				{
					letters[first] = 1;
					first_letters.insert(first);
					found_digits.insert(1);
					moved = true;
					continue;
				}

				const int digits = static_cast<int>(log10(m)); 
				const int first_digit = static_cast<int>(m / pow(10, digits)); 

				if (static_cast<int>(r.second.size()) == digits+1 && known_below(found_digits, first_digit))
				{
					letters[first] = first_digit;
					found_digits.insert(first_digit);
					if(found_digits.size() == 9)
					{
						goto Solved;
					}
					moved = true;
					continue;
				}

				letters[first] = -1;
				first_letters.insert(first);
				if(all_letters.size() < 10)
				{
					for(auto c : r.second)
					{
						all_letters.insert(c);
					}
				}
			}
		} while(moved);
	Solved:
		for(auto kv : letters)
		{
			all_letters.erase(kv.first);
		}
		letters[*all_letters.begin()] = 0;

		for(size_t i = 0; i < 10; i++)
		{
			for(auto kv : letters)
			{
				if(kv.second == i)
				{
					cout << kv.first;
				}
			}
		}
	}

	void Run()
	{
		cout << "Case #" << idx  << ": ";
		Input();
		Solve();
		cout << endl;
	}
};

int main()
{
	int t;
	cin >> t;
	for(int i = 1; i <= t; i++)
	{
		TestCase(i).Run();
	}
}
