#include <algorithm>
#include <cassert>
#include <cstdint>
#include <iostream>
#include <iterator>
#include <limits>
#include <vector>

using namespace std;

int64_t int_pow(int64_t x, int pow) {
  int64_t res = 1;
  for (int i = 0; i < pow; ++i)
    res *= x;
  return res;
}

int main() {
  int tests;
  cin >> tests;
  for (int test = 1; test <= tests; ++test) {
    int u;
    cin >> u;

    constexpr int requests = 1e4;
    string allowed[10];
    string possible[10];
    string seen;
    for (int i = 0; i < 10; ++i) {
      for (char c = 'A'; c <= 'Z'; ++c)
        allowed[i].push_back(c);
    }
    for (char c = 'A'; c <= 'Z'; ++c)
      possible[0].push_back(c);
    for (int r = 0; r < requests; ++r) {
      string s;
      string m;
      cin >> m >> s;

      assert(m[0] != '-');
      if (m.size() != s.size())
        continue;

      for (char c : s) {
        if (find(seen.begin(), seen.end(), c) != seen.end())
          continue;
        seen.push_back(c);
      }

      allowed[0].erase(remove(allowed[0].begin(), allowed[0].end(), s[0]),
                       allowed[0].end());
      for (int x = m[0] - '0' + 1; x < 10; ++x)
        allowed[x].erase(remove(allowed[x].begin(), allowed[x].end(), s[0]),
                         allowed[x].end());
      for (int x = 1; x <= m[0] - '0'; ++x) {
        if (find(possible[x].begin(), possible[x].end(), s[0]) !=
            possible[x].end())
          continue;
        possible[x].push_back(s[0]);
      }
    }
    for (int i = 0; i < 10; ++i) {
      allowed[i].erase(remove_if(allowed[i].begin(), allowed[i].end(),
                                 [&](char c) {
                                   return possible[i].find(c) == string::npos ||
                                          seen.find(c) == string::npos;
                                 }),
                       allowed[i].end());
    }

    string result(10, '2');
    for (int i = 0; i < 10; ++i) {
      auto nxt = find_if(begin(allowed), end(allowed),
                         [](string &v) { return v.size() == 1; });
      assert(nxt != end(allowed));
      char c = nxt->front();
      result[nxt - begin(allowed)] = c;
      for (auto &v : allowed)
        v.erase(remove(v.begin(), v.end(), c), v.end());
    }
    cout << "Case #" << test << ": " << result << "\n";
  }
}