#include <iostream>
#include <istream>
#include <string>
#include <set>
#include <vector>

using namespace std;

void permute(string& a, int l, int r, vector<set<char>>& letters);

string solve(int U, istream input) {
    vector<set<char>> letters; 
    for (int i = 0; i < 10; ++i) {
        letters.push_back({});
    }
    
    set<char> alph;
    
    long long int Q, degree;
    int digit, count;
    string R;
    for (int read = 0; read < 10000; ++read) {
        input >> Q >> R;
        
        if (alph.size() < 10) {
            for (auto& ltr : R) {
                if (alph.find(ltr) != alph.end()) {
                    alph.insert(ltr);
                    for (int i = 0; i < 10; ++i) {
                        letters[i].insert(ltr);
                    }
                }
            }
        }
        
        degree = 1;
        count = 1;
        
        while (Q / degree > 9) {
            degree *= 10;
            count += 1;
        }
        
        letters[0].erase(R[0]);
        
        if (count == R.size()) {
            digit = Q / degree;
            digit += 1;
            while (digit < 10) {
                letters[digit].erase(R[0]);
                digit += 1;
            }
        }
    }
    string arr;
    
    std::copy(alph.begin(), alph.end(), arr.begin());
    
    permute(arr, 0, 9, letters);
    return arr;
}

void permute(string& a, int l, int r, vector<set<char>>& letters)  
{  
    // Base case  
    if (l == r)  
        return;  
    else
    {  
        // Permutations made  
        for (int i = l; i <= r; i++)  
        {  
            if (letters[i].find(a[i]) != letters[i].end()) {
                continue;
            }
            // Swapping done  
            swap(a[l], a[i]);  
  
            // Recursion called  
            permute(a, l+1, r, letters);  
  
            //backtrack  
            swap(a[l], a[i]);  
        }  
    }  
}

int main() {
    int cases, U;
    std::cin >> cases;
    for (int i = 0; i < cases; ++i) {
        std::cin >> U;
        {
            vector<set<char>> letters; 
            for (int i = 0; i < 10; ++i) {
                letters.push_back({});
            }
            
            set<char> alph;
            
            long long int Q, degree;
            int digit, count;
            string R;
            for (int read = 0; read < 10000; ++read) {
                std::cin >> Q >> R;
                
                if (alph.size() < 10) {
                    for (auto& ltr : R) {
                        if (alph.find(ltr) == alph.end()) {
                            alph.insert(ltr);
                            for (int i = 0; i < 10; ++i) {
                                letters[i].insert(ltr);
                            }
                        }
                    }
                }
                
                degree = 1;
                count = 1;
                
                while (Q / degree > 9) {
                    degree *= 10;
                    count += 1;
                }
                
                letters[0].erase(R[0]);
                
                if (count == R.size()) {
                    digit = Q / degree;
                    digit += 1;
                    while (digit < 10) {
                        letters[digit].erase(R[0]);
                        digit += 1;
                    }
                }
            }
            string arr;
            
            for (auto it = alph.begin(); it != alph.end(); ++it) {
                arr += *it;
            }
            //permute(arr, 0, 9, letters);
            std::cout << "Case #" << i + 1 << ": " << arr << std::endl;
        }
    }
}
