#include <iostream>
#include <cstring>
#include <vector>
#include <algorithm>
#include <string>
#include <set>
#include <map>
#include <cmath>
#include <bitset>

using namespace std;
typedef long long LL;

int numd(int n) {
  int d = 0;
  while (n > 0) {
    n /= 10;
    d++;
  }
  return d;
}

const int Q = 1e4;
int U;
vector<pair<LL, string>> queries(Q);
set<char> alpha;
map<char, int> amax;
vector<pair<char, int>> amv;
vector<char> out;
bool quit;

void verify(vector<char> b) {
  int mx, cur = 0;
  string ot, al(b.begin(), b.end());
  // cout << al << endl;
  for (int i = 0; i < Q; i++) {
    tie(mx, ot) = queries[i];
    cur = 0;
    for (int j = 0; j < ot.length(); j++) {
      cur *= 10;
      cur += al.find(ot[j]);
    }
    if (cur > mx || ot.length() > 1 && cur == 0) {
      // cout << mx << ' ' << ot << ' ' << cur << endl;
      return;
    }
  }
  quit = 1;
  out = b;
}

LL pow10(int d) {
  LL r = 1;
  for (int i = 0; i < d; i++) 
    r *= 10;
  return r;
}

void config(int i, vector<char> b) {
  if (i == 10) {
    verify(b);
    return;
  }
  for (int j = 0; j <= amv[i].second; j++) {
    if (b[j] == '0') {
      b[j] = amv[i].first;
      config(i + 1, b);
      b[j] = '0';
    }
    if (quit) return;
  }
}

int main() {   
  ios_base::sync_with_stdio(false);

  int T;
  cin >> T;
  for (int t = 1; t <= T; t++) {
    cout << "Case #" << t << ": ";
    cin >> U;
    quit = false;
    alpha.clear(), amax.clear();
    amv.clear();
    for (int i = 0; i < Q; i++) {
      cin >> queries[i].first >> queries[i].second;
      for (char c: queries[i].second) {
        if (!amax.count(c)) {
          amax[c] = 9;
        }
      }
      int nd = numd(queries[i].first);
      if (nd == queries[i].second.length() && nd > 1) {
        auto fc = queries[i].second[0];
        amax[fc] = min(amax[fc], (int)(queries[i].first / pow10(nd - 1)));
      }
    }

    for (auto x: amax) {
      amv.push_back(x);
      // cout << x.first << ' ' << x.second << endl;
    }
    
    vector<char> sk(10, '0');
    config(0, sk);
    for (auto c: out) {
      cout << c;
    }
    cout << endl;
  }

  return 0;
}