#define _CRT_SECURE_NO_WARNINGS
#include <string>
#include <vector>
#include <iostream>
#include <algorithm>
#include <set>
#include <map>
#include <assert.h>

using namespace std;

typedef long long ll;

int max_value[26];
int min_value[26];
bool is_free[10];

set<char> digits;
map<char, int> values;
char ans[10];
vector<char> letters;

void init()
{
	digits.clear();
	values.clear();
	letters.clear();
	for (int i = 0; i < 26; i++)
	{
		max_value[i] = 9;
		min_value[i] = 0;
	}

	for (int i = 0; i < 10; i++)
	{
		is_free[i] = true;
		ans[i] = -1;
	}

}

void find_max_values(vector<pair<string, string>> & input)
{
	for (int i = 0; i < input.size(); i++)
	{
		for (int j = 0; j < input[i].second.size(); j++)
			digits.insert(input[i].second[j]);
		min_value[input[i].second[0] - 'A'] = 1;
		if (input[i].first != "-1" && input[i].first.size() == input[i].second.size())
		{
			max_value[input[i].second[0] - 'A'] = min(
				max_value[input[i].second[0] - 'A'],
				input[i].first[0] - '0');
		}
	}
}

bool is_can(vector<pair<string, string>> & input)
{
	for (int i = 0; i < input.size(); i++)
	{
		if (input[i].first != "-1")
		{
			if (input[i].first.size() == input[i].second.size())
			{
				bool is_good = true;
				for (int j = 0; j < input[i].first.size(); j++)
				{
					int d1 = input[i].first[j] - '0';
					char l = input[i].second[j];
					if (!values.count(l))
						break;
					int d2 = values[l];
					if (d2 > d1)
					{
						is_good = false;
						break;
					}
					if (d2 < d1)
						break;
				}
				if (!is_good)
					return false;
			}
			else
			{
				if (values.count(input[i].second[0]) && values[input[i].second[0]] == 0)
					return false;
			}
		}
		else
		{
			if (values.count(input[i].second[0]) && values[input[i].second[0]] == 0)
				return false;
		}
	}
	return true;
}

bool iter(int p, vector<pair<string, string>> & input)
{
	if (p == letters.size())
		return true;
	char curent = letters[p];
	for (int d = min_value[curent - 'A']; d <= max_value[curent - 'A']; d++)
	{
		if (is_free[d])
		{
			is_free[d] = false;
			values[curent] = d;			
			if (is_can(input) && iter(p + 1, input))
				return true;
			values.erase(curent);
			is_free[d] = true;
		}
	}
	return false;
}

void solve()
{
	int t = 0;
	cin >> t;
	int case_i = 0;
	while (t--)
	{
		init();
		case_i++;

		ll u = 0;
		cin >> u;
		vector<pair<string, string>> input(10000);
		for (int i = 0; i < 10000; i++)
		{
			cin >> input[i].first >> input[i].second;
			if (input[i].first != "-1")
			{
				assert(input[i].first.size() >= input[i].second.size());
				assert(input[i].first[0] != 0);
			}
			
		}
		find_max_values(input);
		for (auto d : digits)
			letters.push_back(d);
		assert(iter(0, input));
		assert(values.size() == letters.size());
		for (auto v : values)
			ans[v.second] = v.first;
		for (int i = 0; i < 10; i++)
		{
			if (ans[i] == -1)
			{
				for (char l = 'A'; l <= 'Z'; l++)
				{
					if (!digits.count(l))
					{
						values[l] = i;
						digits.insert(l);
						ans[i] = l;
						break;
					}
				}
			}
		}

		set<char> uniq;
		for (int i = 0; i < 10; i++)
		{
			assert(!uniq.count(ans[i]));
			uniq.insert(ans[i]);
			assert('A' <= ans[i] && ans[i] <= 'Z');
		}

		assert(is_can(input));

		cout << "Case #" << case_i << ": ";
		for (int i = 0; i < 10; i++)
			cout << ans[i];
		cout << endl;
	}
}

int main()
{	
	//freopen("input.txt", "r", stdin);
	solve();
	return 0;
}