#include <fstream>
#include <bitset>
#include <iostream>
#include <assert.h>
#include <algorithm>

#define MAXM 10000
#define M MAXM
#define ALF 26
#define ORD(x) (x - 'A')
using namespace std;

int zero;
int U;
int q[M];
string r[M];

int charIndex[ALF + 4];
int indexMapping[10];
char indexChar[10];

bitset<ALF + 4> canBeZero;
bitset<ALF + 4> letterePresenti;

fstream in;
// #define cin in

void init(){
    cin >> U;
    for(int i = 0; i < M; i++)
        cin >> q[i] >> r[i];

    letterePresenti.reset();
    canBeZero.reset();
    fill(charIndex, charIndex + ALF, -1);
}

int aggiungiLettere(string str){
    int s = 0;
    for(auto i:str)
        if(!letterePresenti[ORD(i)])
            s+= 1, letterePresenti[ORD(i)] = true;
    return s;
}

char charOfDigit(int am){
    for(int i = 0; i < 10; i++){
        if(indexMapping[i] == am){
            return indexChar[i];
        }
    }
    assert(false);
}

string getSecret(){
    string s;
    for(int i = 0; i < 10; i++){
        s+= charOfDigit(i);
    }
    return s;
}

int togliCBZ(string str){
    if(canBeZero[ORD(str[0])]){
        canBeZero[ORD(str[0])] = false;
        return 1;
    }
    return 0;
}

int getDigit(char c){
    return indexMapping[charIndex[ORD(c)]];
}

int convertNum(string str){
    int s = 0;
    for(int i = 0; i < str.length(); i++){
        s = (s * 10 + getDigit(str[i]));
    }
    return s;
}

bool validMapping(){
    for(int i = 0; i < M; i++){
        if(q[i] < convertNum(r[i]))
            return false;
    }
    return true;
}

string solve(){
    // troviamo le lettere presenti
    for(int i = 0, f = 0; i < M && f < 10; i++)
        f+= aggiungiLettere(r[i]);

    assert(letterePresenti.count() == 10);

    // trova lo zero
    canBeZero|= letterePresenti;
    for(int i = 0, f = 0; i < M && f < 9; i++)
        f+= togliCBZ(r[i]);

    assert(canBeZero.count() == 1);

    for(int i = 0; i < ALF; i++)
        if(canBeZero[i])
            zero = i;

    // assegna alle lettere 1 -> 9 un indice 1 -> 9
    charIndex[zero] = 0;
    indexMapping[0] = 0;
    indexChar[0] = zero + 'A';

    for(int i = 0, j = 1; i < ALF && j < 10; i++){
        if(letterePresenti[i] && !canBeZero[i]){
            charIndex[i] = indexMapping[j] = j;
            indexChar[j] = i + 'A';
            j++;
        }
    }

    do{
        if(validMapping()){
            return getSecret();
        }
    } while(next_permutation(indexMapping + 1, indexMapping + 10));
    return "uhh";
}

int main(){
    // in.open("overrandomized.txt", ios::in);

    int T;
    cin >> T;

    for(int t = 1; t <= T; t++){
        init();
        cout<<"Case #"<<t<<": "<<solve()<<"\n";
    }
}

