#include <iostream>
#include <vector>
#include <string>
#include <map>
#include <set>
using namespace std;

#ifdef LOCAL
#include "dbg.h"
#else
#define dbg(...)
#endif

constexpr int kNumSamples = 10000;

void solveTest() {
    int numDigits; cin >> numDigits;
    map<char, pair<int, int>> freq;
    for (int i = 0; i < kNumSamples; ++i) {
        string bound; string repr; cin >> bound >> repr;
        for (auto ch : repr) {
            freq[ch].second += 1;
        }
        if (repr.length() == numDigits) {
            freq[repr[0]].first += 1;
        }
    }

    string result(10, 0);
    for (int digit = 1; digit <= 9; ++digit) {
        char bestMapping = -1;
        pair<int, int> mx = {-1, -1};
        for (auto it : freq) {
            if (it.second > mx) {
                bestMapping = it.first;
                mx = it.second;
            }
        }

        result[digit] = bestMapping;
        freq.erase(bestMapping);
    }
    result[0] = freq.begin()->first;
    cout << result << endl;
}

int main() {
    cin.tie(nullptr);
    ios_base::sync_with_stdio(false);

    int numCases; cin >> numCases;
    for (int t = 1; t <= numCases; ++t) {
        cout << "Case #" << t << ": ";
        solveTest();
    }
    return 0;
}
