#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <tuple>

using namespace std;

struct Query {
    string num;
    string res;
};

int64_t Convert(const string &str) {
    stringstream ss(str);
    int64_t num;
    ss >> num;
    return num;
}

string Convert(int64_t num) {
    stringstream ss;
    ss << num;
    return ss.str();
}

void AddProb(const string &rand, const string &chosen,
             double chosen_prob, vector<vector<double>> &prob) {
    if (rand.size() != chosen.size()) {
        return;
    }

    for (size_t i = 0; i < rand.size(); i += 1) {
        prob[rand[i] - 'A'][chosen[i] - '0'] += chosen_prob;
    }
}

void AddProb(const Query &q, vector<vector<double>> &prob) {
    auto n = Convert(q.num);
    for (int64_t i = 1; i <= n; i += 1) {
        AddProb(q.res, Convert(i), 1.0 / n, prob);
    }
}

char PickDigit(int digit, const vector<vector<double>> &prob) {
    char res = 'A';
    for (size_t i = 0; i < prob.size(); i += 1) {
        if (prob[i][digit] > prob[res - 'A'][digit]) {
            res = 'A' + i;
        }
    }
    return res;
}

string Solve(const vector<Query> &queries) {
    vector<vector<double>> prob(26, vector<double>(10, 0));
    for (const auto &q : queries) {
        AddProb(q, prob);
    }

    /*
    auto PrintRow = [&prob](char ch) {
        cerr << ch << ": ";
        for (int i = 0; i < 10; i += 1) {
            cerr << i << "(" << prob[ch - 'A'][i] << ")  ";
            if (i == 4) {
                cerr << "\n  ";
            }
        }
        cerr << "\n";
    };
    for (const auto &ch : "TPFOXLUSHB") {
        if ('A' <= ch && ch <= 'Z') {
            PrintRow(ch);
        }
    }*/

    vector<tuple<double, char, int>> probs;
    for (int i = 0; i < 26; i += 1) {
        for (int j = 0; j < 10; j += 1) {
            probs.push_back(make_tuple(prob[i][j], 'A' + i, j));
        }
    }
    sort(probs.begin(), probs.end(), greater<tuple<double, char, int>>());

    vector<bool> busy(26, false);

    string res(10, 0);
    for (const auto &t : probs) {
        auto ch = get<1>(t);
        auto digit = get<2>(t);

        if (res[digit] == 0 && !busy[ch - 'A']) {
            res[digit] = ch;
            busy[ch - 'A'] = true;
        }
    }
    return res;
}

int main() {
    int tests;
    cin >> tests;

    for (int i = 1; i <= tests; i += 1) {
        int digits;
        cin >> digits;
        cin.get();

        constexpr int kQueries = 1e4;
        vector<Query> queries(kQueries);
        for (auto &q : queries) {
            cin >> q.num >> q.res;
        }

        auto res = Solve(queries);
        cout << "Case #" << i << ": " << res << "\n";
    }
    return 0;
}
