#include <algorithm>
#include <iostream>
#include <iomanip>
#include <map>
#include <set>
#include <vector>
using namespace std;

bool possible(string& D, long long x, string& t) {
    bool putz = false;
    long long cur = 0;

    for ( int i = 0; i < t.size(); ++i ) {
        int x = D.find(t[i]);
        if ( x == 0 && !putz ) return false;
        cur = cur * 10 + x;
        putz = true;
    }
    return cur <= x;
}

int main() {
    int t, nc = 0; cin >> t;
    while ( t-- ) {
        map<long long, set<string>> values;
        set<char> unq;
        vector<pair<long long, string>> all;
        int n; cin >> n;
        long long x;
        string s, answer(10, '0');

        for ( int i = 0; i < 1e4; ++i ) {
            cin >> x >> s;
            if ( x < 10 )
                values[x].insert(s);
            all.push_back({x, s});
            for ( auto ch : s ) unq.insert(ch);
        }

        while ( values.size() ) {
            for (auto cur : values ) {
                if ( cur.second.size() == 1 ) {
                    string tmp = *cur.second.begin();
                    answer[cur.first] = tmp[0];
                    for ( int i = 0; i < 10; ++i ) {
                        if ( values.count(i) && values[i].count(tmp) ) {
                            values[i].erase(tmp);
                            if ( values[i].size() == 0 ) {
                                values.erase(i);
                            }
                        }
                    }
                    break;
                }
            }
        }
        vector<char> can_assign;
        vector<int> pos;
        for ( int i = 0; i < answer.size(); ++i ) {
            if ( answer[i] == '0' ) {
                pos.push_back(i);
            }
        }
        for ( auto ch : unq ) {
            if ( answer.find(ch, 0) == string::npos ) {
                can_assign.push_back(ch);
            }
        }
        sort(can_assign.begin(), can_assign.end());

        do {
            string tmp = answer;
            for ( int i = 0; i < pos.size(); ++i ) {
                tmp[pos[i]] = can_assign[i];
            }
            bool ok = true;
            for ( int i = 0; ok && i < all.size(); ++i ) {
                ok &= possible(tmp, all[i].first, all[i].second);
            }
            if ( ok ) {
                answer = tmp; break;
            }
        } while (next_permutation(can_assign.begin(), can_assign.end()));

        cout << "Case #" << ++nc << ": ";
        cout << answer << endl;
    }
    return 0;
}