#include <bits/stdc++.h>

using namespace std;

// Common Utilities
//______________________________________________________________________________

// Macros
#ifdef D3BUG
    #define cerrd if (D3BUG) cerr
#else
    #define cerrd if (false) cerr
#endif

// Types
template <typename T> using vector1D = vector<T>;
template <typename T> using vector2D = vector<vector1D<T>>;
template <typename T> using vector3D = vector<vector2D<T>>;
template <typename T> using uset = unordered_set<T>;
template <typename K, typename V> using umap = unordered_map<K, V>;

// Output stream overloads.
template <typename T>
ostream& operator<<(ostream& out, const vector<T>& v) {
    if (v.size() == 0) {
        return out << "[]";
    }

    out << '[' << v[0];
    for (int i = 1; i < v.size(); ++i) {
        out << ' ' << v[i];
    }
    return out << ']';
}

template <typename T>
ostream& operator<<(ostream& out, const vector<vector<T>>& m) {
    if (m.size() == 0) {
        return out << "[]";
    }

    for (const auto& row : m) {
        out << row << '\n';
    }
    return out;
}

template <typename T>
ostream& operator<<(ostream& out, const deque<T>& d) {
    if (d.size() == 0) {
        return out << "[]";
    }

    out << '[' << d[0];
    for (int i = 1; i < d.size(); ++i) {
        out << ' ' << d[i];
    }
    return out << ']';
}

template <typename T>
ostream& operator<<(ostream& out, const set<T>& s) {
    if (s.size() == 0) {
        return out << "{}";
    }

    out << '{' << *s.begin();
    for (auto it = ++s.begin(); it != s.end(); ++it) {
        out << ' ' << *it;
    }
    return out << '}';
}

template <typename T>
ostream& operator<<(ostream& out, const multiset<T>& s) {
    return out << vector<T>(s.begin(), s.end());
}

template <typename T>
ostream& operator<<(ostream& out, const unordered_set<T>& s) {
    if (s.size() == 0) {
        return out << "{}";
    }

    vector<T> v(s.begin(), s.end());
    sort(v.begin(), v.end());

    out << '{' << v[0];
    for (int i = 1; i < v.size(); ++i) {
        out << ' ' << v[i];
    }
    return out << '}';
}

template <typename K, typename V>
ostream& operator<<(ostream& out, const map<K, V>& m) {
    if (m.size() == 0) {
        return out << "{}";
    }

    vector<K> keys;
    for (const auto& p : m) {
        keys.push_back(p.first);
    }

    out << "{" << keys[0] << ": " << m.at(keys[0]);
    for (int i = 1; i < keys.size(); ++i) {
        const auto& key = keys[i];
        out << ", " << key << ": " << m.at(key);
    }
    return out << '}';
}

template <typename K, typename V>
ostream& operator<<(ostream& out, const unordered_map<K, V>& m) {
    if (m.size() == 0) {
        return out << "{}";
    }

    vector<K> keys;
    for (const auto& p : m) {
        keys.push_back(p.first);
    }
    sort(keys.begin(), keys.end());

    out << "{" << keys[0] << ": " << m.at(keys[0]);
    for (int i = 1; i < keys.size(); ++i) {
        const auto& key = keys[i];
        out << ", " << key << ": " << m.at(key);
    }
    return out << '}';
}

template <typename F, typename S>
ostream& operator<<(ostream& out, const pair<F, S>& p) {
    return out << '(' << p.first << ", " << p.second << ')';
}

namespace std {
    template<typename T, typename U>
    struct hash<pair<T, U>> {
        size_t operator()(const pair<T, U>& p) const noexcept {
            return hash<T>{}(p.first) ^ (hash<U>{}(p.second) << 1);
        }
    };
}

// Forward declaration of the solution function.
void solution();

// Initialize the execution environment and call the solution function.
int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    solution();
    return 0;
}

// Solution
//______________________________________________________________________________

constexpr long long MOD = 998244353LL;

bool find_matching(vector<uset<char>>& mapping, int digit, string& valuation) {
    if (digit == 10) {
        return true;
    }
    for (char c : mapping[digit]) {
        valuation.push_back(c);
        vector<int> affected;
        for (int d = digit + 1; d < 10; ++d) {
            if (mapping[d].find(c) != mapping[d].end()) {
                affected.push_back(d);
                mapping[d].erase(c);
            }
        }
        if (find_matching(mapping, digit + 1, valuation)) {
            return true;
        }
        for (int d : affected) {
            mapping[d].emplace(c);
        }
        valuation.pop_back();
    }
    return false;
}

string solve(int u, vector<pair<long long, string>>& inputs) {
    uset<char> digits;
    for (const auto& input : inputs) {
        const auto& result = input.second;
        for (char c : result) {
            digits.insert(c);
        }
    }
    if (digits.size() != 10) {
        cerr << "Error.  Digit size is not 10.\n";
        return "";
    }
    // cerr << "Digits = " << digits << '\n'; 
    vector<uset<char>> mapping(10);
    for (int i = 0; i < 10; ++i) {
        for (char c : digits) {
            mapping[i].emplace(c);
        }
    }
    // umap<char, int> lowest;
    // for (char c : digits) {
    //     lowest[c] = 9;
    // }
    uset<char> firsts;
    for (const auto& input : inputs) {
        firsts.emplace(input.second[0]);
        long long m = input.first;
        int length = 1;
        while (m >= 10) {
            m /= 10LL;
            ++length;
        }
        if (length != input.second.length()) {
            continue;
        }
        // cerr << input << '\n';
        int digit = m;
        char letter = input.second[0];
        // if (lowest[letter] <= digit) {
        //     continue;
        // }
        // lowest[letter] = digit;
        for (int d = digit + 1; d < 10; ++d) {
            mapping[d].erase(letter);
        }
        // for (int d = 1; d <= digit; ++d) {
        //     mapping[d].emplace(letter);
        // }
    }
    for (char c : firsts) {
        mapping[0].erase(c);
    }
    // cerr << "Mapping = " << mapping << '\n';
    string valuation = "";
    bool resolve = find_matching(mapping, 0, valuation);
    // cerr << "Valuation = " << valuation << '\n';
    if (!resolve) {
        cerr << "Error: unresolved.\n";
    }
    return valuation;
}

void solution() {
    int T;
    cin >> T;
    for (int t = 1; t <= T; ++t) {
        int u;
        cin >> u;
        vector<pair<long long, string>> inputs;
        for (int i = 0; i < 10000; ++i) {
            long long m;
            string r;
            cin >> m >> r;
            inputs.emplace_back(m, r); 
        }
        string answer = solve(u, inputs);
        cout << "Case #" << t << ": " << answer << '\n';
    }
}