#include <iostream>
#include <cmath>
#include <algorithm>
#include <vector>
#include <deque>
#include <set>
#include <map>
#include <unordered_map>
#include <unordered_set>
#include <iomanip>
#include <string>
#include <sstream>

using namespace std;

string solve() {
    int u;
    cin >> u;
    unordered_map<int, vector<string>> queries;

    for (int i = 0; i < 10000; i++) {
        int q;
        string n;
        cin >> q >> n;

        queries[q].push_back(n);
    }

    string ans(10, '0');
    set<char> used;

    for (int digit = 1; digit < 10; digit++) {
        for (string& var : queries[digit]) {
            if (used.find(var[0]) == used.end()) {
                ans[digit] = var[0];
                used.insert(var[0]);
            }
        }
    }

    for (string& var : queries[10]) {
        if (var.size() == 2) {
            ans[0] = var[1];
        }
    }

    return ans;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;

    for (int q = 1; q <= t; ++q) {
        string ans = solve();
        cout << "Case #" << q << ": " << ans << "\n";
    }

    return 0;
}
