#include <array>
#include <cassert>
#include <cctype>
#include <cstdint>
#include <iostream>
#include <set>
#include <string>
#include <vector>
using namespace std;

const size_t kNumQueries = 10000;

struct Query {
  Query() = default;

  int64_t m_q = 0;
  string m_r;

  bool m_alwaysTrue = false;
};

struct Solution {
  Solution() {
    fill(m_charToDigit.begin(), m_charToDigit.end(), -1);
  }

  array<int, 'Z' - 'A' + 1> m_charToDigit = {};
  array<char, 10> m_digitToChar = {};
  vector<char> m_unused;
};

bool IsValid(const Solution& solution, const vector<Query>& queries) {
  for (const auto& query : queries) {
    if (solution.m_charToDigit[query.m_r[0] - 'A'] == 0)
      return false;

    if (query.m_q < 0 || query.m_alwaysTrue)
      continue;

    int64_t value = 0;
    bool empty = true;
    for (size_t i = 0; i < query.m_r.size(); ++i) {
      value = value * 10;
      if (solution.m_charToDigit[query.m_r[i] - 'A'] != -1) {
        value += solution.m_charToDigit[query.m_r[i] - 'A'];
        empty = false;
      }
    }

    if (!empty && (value > query.m_q || value < 1))
      return false;
  }

  return true;
}

bool Solve(int digit, Solution& curr, const vector<Query>& queries, Solution& result) {
  if (digit < 0) {
    result = curr;
    return true;
  }
  for (size_t i = 0; i < curr.m_unused.size(); ++i) {
    const auto c = curr.m_unused[i];
    curr.m_charToDigit[c - 'A'] = digit;
    curr.m_digitToChar[digit] = c;
    if (IsValid(curr, queries)) {
      swap(curr.m_unused[i], curr.m_unused.back());
      curr.m_unused.pop_back();
      if (Solve(digit - 1, curr, queries, result))
        return true;
      curr.m_unused.push_back(c);
      swap(curr.m_unused[i], curr.m_unused.back());
    }
    curr.m_charToDigit[c - 'A'] = -1;
  }
  return false;
}

istream& operator>>(istream& is, Query& q) {
  is >> q.m_q >> q.m_r;
  return is;
}

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(nullptr);

  int numTests;
  cin >> numTests;

  for (int testNum = 1; testNum <= numTests; ++testNum) {
    int U;
    cin >> U;
    vector<Query> queries(kNumQueries);

    bool here['Z' - 'A' + 1] = {};
    for (auto& query : queries) {
      cin >> query;
      for (char c : query.m_r) {
        assert(isalpha(c) && isupper(c));
        here[c - 'A'] = true;
      }

      int64_t value = 0;
      for (size_t i = 0; i < query.m_r.size(); ++i)
        value = value * 10 + 9;
      if (value < query.m_q)
        query.m_alwaysTrue = true;
    }
    vector<char> digits;
    for (size_t i = 0; i < 'Z' - 'A' + 1; ++i) {
      if (here[i])
        digits.push_back('A' + i);
    }
    assert(digits.size() == 10);

    Solution curr;
    for (auto& c : digits)
      curr.m_unused.push_back(c);

    Solution result;
    const bool ok = Solve(9, curr, queries, result);
    assert(ok);
    string d;
    for (const auto& c : result.m_digitToChar)
      d.push_back(c);

    cout << "Case #" << testNum << ": " << d << endl;
  }
  return 0;
}
