#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
#include <unordered_map>
#include <unordered_set>
#include <map>
#include <set>
#include <random>

// #include "matplotlibcpp.h"

using namespace std;
// namespace plt = matplotlibcpp;

typedef long long ll; typedef unsigned long long ull; typedef vector<ll> vi; typedef pair<ll,ll> pi;
const int _1e5 = 100000; const int _1e7 = 10000000; const int _1e9 = 1000000000;
const int _1e4 = 10000;
const ll _1e16 = 10000000000000000;

template<typename A, typename B> ostream& operator<<(ostream& str, const pair<A,B>& p) { return str << "(" << p.first << ", " << p.second << ")"; }
template<typename T> ostream& operator<<(ostream& str,             const vector<T>& v) { str << "["; for(auto n : v) str << n << ", "; return str << "]"; }
template<typename T> ostream& operator<<(ostream& str,             const vector<vector<T>>& v) { for(auto n : v) str << n << "\n"; return str; }
template<typename T> ostream& operator<<(ostream& str,             const set<T>& v) { str << "{"; for(auto n : v) str << n << ", "; return str << "}"; }
template<typename K, typename V> ostream& operator<<(ostream& str, const map<K, V>& v) { str << "{"; for(auto&& p : v) str << p.first << " => " << p.second << ", "; return str << "}"; }
template<typename K, typename V> ostream& operator<<(ostream& str, const unordered_set<K, V>& v) { str << "{"; for(auto&& p : v) str << p.first << " => " << p.second << ", "; return str << "}"; }
template<typename K, typename V> ostream& operator<<(ostream& str, const unordered_map<K, V>& v) { str << "{"; for(auto&& p : v) str << p.first << " => " << p.second << ", "; return str << "}"; }
#define debug(x) cerr <<  #x  << ": " << x << endl

// random_device rd;
// default_random_engine rng(rd());

// void generate_testcase() {
// 	vi answers;

// 	std::uniform_int_distribution<ll> qdist(1, _1e16-1);
// 	for (int i=0; i<10000; ++i) {
// 		ll qi = qdist(rng);
// 		std::uniform_int_distribution<ll> rdist(1, qi);
// 		ll ri = rdist(rng);
// 		answers.push_back(ri);
// 	}

// 	// map<int, int> first_digits;
// 	// map<int, int> last_digits;
// 	vi first_digits_x(10, 0);
// 	vi first_digits_y(10, 0);
// 	vi last_digits_x;
// 	vi last_digits_y(10, 0);
// 	for (auto ri : answers) {
// 		vector<int> digits(16);
// 		for (auto d=digits.rbegin(); d!=digits.rend(); ++d) {
// 			*d = ri % 10;
// 			ri /= 10;
// 		}
// 		++first_digits_y[digits.front()];
// 		++last_digits_y[digits.back()];
// 	}

// 	plt::plot(first_digits_y);
// 	// // plt::named_plot("last", last_digits_y);
// 	plt::show();
// }

struct df {
	char digit;
	ll frequency;
};

int main() {
	ios_base::sync_with_stdio(false);
	// generate_testcase();

	int t; cin >> t;
	for (int case_=1; case_<=t; ++case_) {
		ll u; cin >> u;

		map<char, int> first_digits;

		for (int i=0; i<_1e4; ++i) {		
			ll qi;
			string ri;
			cin >> qi >> ri;

			// debug(ri);
			for (auto c: ri) {
				first_digits[c];
			}
			++first_digits[ri[0]];
		}

		vector<df> dfs;
		for (auto& kv : first_digits) {
			dfs.push_back(df {kv.first, kv.second});
		}

		// debug(dfs);
		// debug(first_digits);

		sort(dfs.begin(), dfs.end(), [] (const df& lhs, const df& rhs) {
			return lhs.frequency > rhs.frequency;
		});

		std::string d;
		d += dfs.back().digit;
		for (int i=0; i<dfs.size()-1; ++i) {
			d += dfs[i].digit;
		}

		cout << "Case #" << case_ << ": " << d << std::endl;
	}
}
