#include <bits/stdc++.h>
using namespace std;

int numDigits(long long number) {
  return to_string(number).size();
}

void solve() {
  int U;
  cin >> U;

  const int Q = 10000;
  vector<pair<long long, string>> queries(Q);
  set<char> occuring_letters;
  for (int i = 0; i < Q; ++i) {
    cin >> queries[i].first >> queries[i].second;

    for (char c : queries[i].second) {
      occuring_letters.insert(c);
    }
  }

  // sort(queries.begin(), queries.end());
  sort(queries.begin(), queries.end());

  unordered_map<char, int> freq;
  for (int i = 0; i < Q; ++i) {
    ++freq[queries[i].second[0]];
  }

  set<pair<int, char>> s;
  for (auto p : freq) {
    s.insert(make_pair(p.second, p.first));
  }

  string answer;
  for (auto p : s) {
    answer += p.second;
  }

  // Now we only need to put char 0. It's the remaining one.
  for (char c : occuring_letters) {
    bool does_not_occur_in_answer = true;
    for (int i = 0; i < answer.size(); ++i) {
      if (answer[i] == c) does_not_occur_in_answer = false;
    }
    if (does_not_occur_in_answer) {
      answer += c;
      break;
    }
  }

  reverse(answer.begin(), answer.end());

  cout << answer << endl;
}

int main() {
  int num_cases;
  cin >> num_cases;
  for (int i = 0; i < num_cases; ++i) {
    cout << "Case #" << i + 1 << ": ";
    solve();
  }
}