#include <algorithm>
#include <cmath>
#include <iostream>
#include <map>
#include <numeric>
#include <queue>
#include <set>
#include <stack>
#include <unordered_map>
#include <unordered_set>
#include <vector>

constexpr int NUM_OF_QUERIES = 10000;

std::int64_t mypow10(int p)
{
    std::int64_t res = 1;
    while (p--)
    {
        res *= 10;
    }
    return res;
}

std::string solveFor2(std::vector<std::set<std::pair<std::int64_t, std::string>>>& queries)
{
    std::map<int, std::set<char>> poss;
    std::unordered_set<char> used;
    {
        for (int i = 1; i <= 10; ++i)
        {
            for (auto& p : queries.back())
            {
                if (used.count(p.second[0]))
                {
                    continue;
                }

                if (p.first < i * mypow10(queries.size() - 1))
                {
                    poss[i].insert(p.second[0]);
                }
            }
            used.insert(*poss[i].begin());
        }
    }

    std::string res;
    for ( auto& p : poss)
    {
        res += *p.second.begin();
    }

    for (auto& p : queries[1])
    {
        if (res.find(p.second[1]) == std::string::npos)
        {
            res = p.second[1] + res;
        }
    }
    return res;
}

int main()
{
    int tests;
    std::cin >> tests;
    for (int test = 1; test <= tests; ++test)
    {
        int u;
        std::cin >> u;
        std::vector<std::set<std::pair<std::int64_t, std::string>>> queries(u);
        for (int i = 0; i < NUM_OF_QUERIES; ++i)
        {
            std::int64_t q;
            std::cin >> q;
            std::string s;
            std::cin >> s;
            queries[s.size() - 1].insert(std::make_pair(q,std::move(s)));
        }

        std::cout << "Case #" << test << ": "
                  << solveFor2(queries)
                  << '\n';
    }
    return 0;
}
