#include <iostream>
#include <vector>
#include <unordered_map>
#include <map>
#include <unordered_set>
#include <set>
#include <algorithm>
#include <list>
#include <queue>
#include <functional>
#include <cmath>
#include <stack>
#include <iomanip>

using namespace std;
using ll = long long;

ll U;
unordered_map<char, ll> char_repetitions;
unordered_set<char> first_chars;
string answer;
vector<string> results;
vector<string> q_vals;

void print(ll test_case_no)
{
    cout << "Case #" << test_case_no << ": " << answer << endl;
}

void reset()
{
    answer = "";
    char_repetitions.clear();
    first_chars.clear();
    results.clear();
    q_vals.clear();
}

void read_input()
{
    cin >> U;
    
    for (ll i = 0; i < 10000; ++i)
    {
        ll Q;
        cin >> Q;
        
        string R;
        cin >> R;
        
        q_vals.push_back(to_string(Q));
        results.push_back(R);
        
        first_chars.emplace(R[0]);
        for (ll i = 0; i < R.size(); ++i)
        {
            char c = R[i];
            
            char_repetitions[c] += R.size() - i;
        }
    }
}

void solve()
{
    char zero_char = 'x';
    
    for (auto item : char_repetitions)
    {
        char c = item.first;
        if (first_chars.find(c) == first_chars.end())
        {
            answer.push_back(c);
            zero_char =  c;
            break;
        }
    }
    
    map<ll, set<char>> posibilities;
    
    multimap<ll, char> sorted_chars;
    
    for (auto item : char_repetitions)
    {
        char c = item.first;
        ll repetitions = item.second;
        
        if (c == zero_char)
            continue;
        
        sorted_chars.emplace(repetitions, c);
        
        for (ll i = 1; i <= 9; ++i)
        {
            posibilities[i].emplace(c);
        }
    }
    
    bool bFirst = false;
    
    for (ll i = 0; i < 10000; ++i)
    {
        string Q = q_vals[i];
        string R = results[i];
        
        if (Q == "-1")
        {
            bFirst = true;
            break;
        }
    }
    
    if (bFirst)
    {
        
         auto ite = sorted_chars.rbegin();
          auto iteEnd = sorted_chars.rend();
          
          while (ite != iteEnd)
          {
              char c = ite->second;
              ++ite;
              
              if (c == zero_char)
                  continue;
              
              answer.push_back(c);
          }
        
        return;
    }
    
    
    ////////////////
    map<char, ll> known_digit;
    known_digit.emplace(zero_char, 0);
    
    while (known_digit.size() < 10)
    {
        for (ll i = 0; i < 10000; ++i)
        {
            string Q = q_vals[i];
            string R = results[i];
            
            if (Q == "-1")
            {
                bFirst = true;
                break;
            }
            
            if (Q.size() != R.size())
                continue;
            
            for (ll j = 0; j <= (ll)Q.size(); ++j)
            {
                ll q_digit = Q[j] - '0';
                char r_char = R[j];
                
                if (known_digit.find(r_char) == known_digit.end())
                {
                    for (ll k = q_digit + 1; k <= 9; ++k)
                    {
                        posibilities[k].erase(r_char);
                    }
                    
                    break;
                }
                
                
                if (known_digit[r_char] == q_digit)
                    continue;
            }
            
        }
        
        bool found = false;
        for (ll j = 1; j <= 9; ++j)
        {
            if (posibilities[j].size() == 1)
            {
                char c = *posibilities[j].begin();
                
                if (known_digit.find(c) == known_digit.end())
                    found = true;
                
                known_digit.emplace(c, j);
     
                
            }
        }
        
        if (found == false)
            break;
    }
    
    
    
        set<char> used_chars;
      string tmp_ans;
      for (int i = 9; i >= 1; --i)
      {
          bool found = false;
          for (auto item : known_digit)
          {
              if (item.second == i)
              {
                  used_chars.emplace(item.first);
                  found = true;
                  break;
              }
          }
          
          if (found)
              continue;
          
          ll max_repetitions = 0;
          char candidate = 'x';
          
          for (char c : posibilities[i])
          {
              if (used_chars.find(c) != used_chars.end())
                  continue;
              
              ll r = char_repetitions[c];
              if (max_repetitions < r)
              {
                  candidate = c;
                  max_repetitions = r;
              }
          }
          
          used_chars.emplace(candidate);
          
          known_digit[candidate] = i;
      }
    
    for (ll i = 1; i <= 9; ++i)
    {
        for (auto item : known_digit)
        {
            if (item.second == i)
            {
                answer.push_back(item.first);
                break;
            }
        }
        
    }
      
    
}

int main(int argc, char* argv[])
{
    std::cout << std::fixed;
    std::cout << std::setprecision(6);

    ll T = 0;
    cin >> T;
    
    for (ll test_case_no = 1; test_case_no <= T; ++test_case_no)
    {
        reset();
        read_input();
        solve();
        print(test_case_no);
    }
    return 0;
}



