#include <random>
#include "bits/stdc++.h"

using namespace std;

using ll = long long;
using ld = long double;
using P = pair<int, int>;
constexpr ld eps = 1e-12;
constexpr int inf = numeric_limits<int>::max() / 2;
constexpr int mod = 1e9 + 7;

template <typename T>
void printv(const vector<T> &v) {
  int sz = v.size();
  for (int i = 0; i < sz; i++) {
    cout << v[i] << " \n"[i == sz - 1];
  }
}

const int MAX_N = 10000;

void solve(int u, vector<ll> ms, vector<string> rs, set<char> cs,
           set<char> inis) {
  string ret = "$$$$$$$$$$";
  for (auto c : cs) {
    if (inis.count(c)) continue;
    ret[0] = c;
  }
  vector<char> cand;
  for (auto c : inis) cand.push_back(c);
  do {
    bool f = true;
    string tmp = ret;
    map<char, char> inv;
    inv[ret[0]] = '0';
    for (int i = 0; i < 9; i++) {
      inv[cand[i]] = '0' + i + 1;
      tmp[i + 1] = cand[i];
    }
    for (int i = 0; i < MAX_N; i++) {
      if (ms[i] == -1) continue;
      auto s = rs[i];
      int sz = s.size();
      for (int j = 0; j < sz; j++) {
        s[j] = inv[s[j]];
      }
      if (stoll(s) > ms[i]) {
        f = false;
        break;
      }
    }
    if (f) {
      ret = tmp;
      break;
    }
  } while (next_permutation(cand.begin(), cand.end()));
  cout << ret << endl;
}

ld simu() {
  const ll MAX_U = 1e16;
  mt19937_64 rnd;
  ld sum = 0;
  for (int i = 0; i < MAX_N; i++) {
    ll mi = rnd() % MAX_U;
    ll ni = rnd() % mi;
    sum += ni;
  }
  return sum;
}

void solve2(int u, vector<ll> ms, vector<string> rs, set<char> cs,
            set<char> inis) {
  string ret = "$$$$$$$$$$";
  ld dif = 1e20, cri = simu();
  for (auto c : cs) {
    if (inis.count(c)) continue;
    ret[0] = c;
  }
  vector<char> cand;
  for (auto c : inis) cand.push_back(c);
  map<char, vector<ll>> cnt;
  for (auto c : cand) {
    for (int j = 0; j < 16; j++) cnt[c].push_back(0);
  }
  for (int i = 0; i < MAX_N; i++) {
    reverse(rs[i].begin(), rs[i].end());
    int sz = rs[i].size();
    for (int j = 0; j < sz; j++) {
      auto c = rs[i][j];
      cnt[c][j]++;
    }
  }
  // p[i] = 10^i
  vector<ll> p(20, 1);
  for (int i = 1; i < 16; i++) p[i] = p[i - 1] * 10;
  do {
    string tmp = ret;
    map<char, ll> inv;
    inv[ret[0]] = 0;
    for (int i = 0; i < 9; i++) {
      inv[cand[i]] = i + 1;
      tmp[i + 1] = cand[i];
    }
    // inv := char -> ll
    ld sum = 0;
    for (auto c : cand) {
      for (int j = 0; j < 16; j++) {
        sum += ld(cnt[c][j]) * p[j] * inv[c];
      }
    }
    if (abs(sum - cri) < dif) {
      dif = abs(sum - cri);
      ret = tmp;
    }
  } while (next_permutation(cand.begin(), cand.end()));
  cout << ret << endl;
}

int main() {
  cin.tie(0);
  ios::sync_with_stdio(false);

  int t;
  cin >> t;
  for (int kaf = 1; kaf <= t; kaf++) {
    cout << "Case #" << kaf << ": ";
    int u;
    cin >> u;
    vector<ll> ms(MAX_N);
    vector<string> rs(MAX_N);
    set<char> cs, inis;
    for (int i = 0; i < MAX_N; i++) {
      cin >> ms[i] >> rs[i];
      for (auto c : rs[i]) {
        cs.insert(c);
      }
      inis.insert(rs[i][0]);
    }
    assert((int)cs.size() == 10);
    assert((int)inis.size() == 9);
    if (ms[0] != -1) {
      solve(u, ms, rs, cs, inis);
      continue;
    }
    solve2(u, ms, rs, cs, inis);
  }
}
