#include <cmath>
#include <cstdio>
#include <vector>
#include <iostream>
#include <map>
#include <set>
#include <algorithm>
#include <cstring>
#include <queue>
#include <sstream>

#define MAX_N 100010

using namespace std;


int main() {
    // freopen("input.txt", "r", stdin);
    // freopen("output.txt", "w", stdout);

    int tc;
    cin >> tc;

    for (int tc_i = 0; tc_i < tc; tc_i++) {
        cout << "Case #" << (tc_i + 1) << ": ";

        int u;
        cin >> u;

        map<char, int> charUpperBound;
        map<char, int> charLowerBound;

        char A = 'A';
        for (int i = 0; i < 26; i++) {
            charUpperBound[A + i] = 11;
            charLowerBound[A + i] = -1;
        }

        bool rockMode = false;

        for (int i = 0; i < 10000; i++) {
            long long x;
            string val;
            cin >> x >> val;

            rockMode = x == -1;

            int digit[20];
            int digitLength = 0;

            if (!rockMode) {
                while (x) {
                    digit[digitLength++] = x % 10;
                    x /= 10;
                }

                for (int j = 0; j < (digitLength/2); j++) {
                    swap(digit[j], digit[digitLength - 1 - j]);
                }

                if (digitLength == val.length()) {
                    charUpperBound[val[0]] = min(charUpperBound[val[0]], digit[0]);
                }
            }
            else {
                charUpperBound[val[0]] = min(charUpperBound[val[0]], 9);
                charLowerBound[val[0]] = 1;
            }

            for (int j = 1; j < val.length(); j++) {
                charUpperBound[val[j]] = min(charUpperBound[val[j]], 10);
            }
        }

        char res[10];

        if (!rockMode) {
            for (int i = 0; i < 26; i++) {
                char chr = (char)(A + i);
                int position = charUpperBound[chr];

                if (position < 11) {
                    if (position == 10) {
                        position = 0;
                    }

                    res[position] = chr;
                }
            }

            for (int i = 0; i < 10; i++) {
                cout << res[i];
            }

        }
        else {
            char Zero = -1;
            int positionLength = 0;

            for (int i = 0; i < 26; i++) {
                char chr = (char)(A + i);
                int position = charUpperBound[chr];
                int lb = charLowerBound[chr];

                if (position < 11) {
                    res[positionLength++] = chr;

                    if (lb == -1) {
                        Zero = chr;
                    }
                }
            }

            cout << Zero;

            for (int i = 0; i < 10; i++) {
                if (Zero != res[i])
                cout << res[i];
            }
        };

        cout << endl;
    }

    return 0;
}