#include <algorithm>
#include <iostream>
#include <string>
#include <vector>

using namespace std;

const string ENDL = "\n";


string solve(int u, const vector<pair<int, string>>& queries) {
    static int counts[128];
    static int counts2[128];
    static int firstCounts[128];
    for (char c = 'A'; c <= 'Z'; c++) {
        counts[c] = 0;
        counts2[c] = 0;
        firstCounts[c] = 0;
    }

    for (pair<int, string> query : queries) {
        int m = query.first;
        string r = query.second;

        int thr = u - 2;
        if (r.length() >= thr) {
            for (int i = 0; i < u - thr; i++) {
                counts2[r[i]] += 1;
            }
        }

        for (char c : r) {
            counts[c] += 1;
        }
        firstCounts[r[0]] += 1;
    }

    vector<pair<int, char>> countPairs;
    for (char c = 'A'; c <= 'Z'; c++) {
        if (counts[c] == 0) continue;

        countPairs.push_back(make_pair(counts2[c], c));
    }
    sort(countPairs.begin(), countPairs.end(), greater<pair<int, char>>());

    char zeroChar = '\0';
    for (char c = 'A'; c <= 'Z'; c++) {
        if (counts[c] == 0) continue;

        if (firstCounts[c] == 0) {
            zeroChar = c;
            break;
        }
    }

    string d = "";
    d += zeroChar;
    for (pair<int, char> pair : countPairs) {
        char c = pair.second;
        if (c == zeroChar) continue;

        d += c;
    }

    return d;
}


string solve_small(int u, const vector<pair<int, string>>& queries) {
    static int counts[128];
    static int firstCounts[128];
    for (char c = 'A'; c <= 'Z'; c++) {
        counts[c] = 0;
        firstCounts[c] = 0;
    }

    for (pair<int, string> query : queries) {
        int m = query.first;
        string r = query.second;

        for (char c : r) {
            counts[c] += 1;
        }
        firstCounts[r[0]] += 1;
    }

    vector<pair<int, char>> countPairs;
    for (char c = 'A'; c <= 'Z'; c++) {
        if (counts[c] == 0) continue;

        countPairs.push_back(make_pair(counts[c], c));
    }
    sort(countPairs.begin(), countPairs.end(), greater<pair<int, char>>());

    char zeroChar = '\0';
    for (char c = 'A'; c <= 'Z'; c++) {
        if (counts[c] == 0) continue;

        if (firstCounts[c] == 0) {
            zeroChar = c;
            break;
        }
    }

    string d = "";
    d += zeroChar;
    for (pair<int, char> pair : countPairs) {
        char c = pair.second;
        if (c == zeroChar) continue;

        d += c;
    }

    return d;
}


int main() {
    //freopen("sample.in.txt", "r", stdin);

    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);

    int T;
    cin >> T;

    for (int tc = 1; tc <= T; tc++) {
        int u;
        vector<pair<int, string>> queries;

        cin >> u;
        for (int i = 0; i < 10000; i++) {
            int q;
            string r;
            cin >> q >> r;
            queries.push_back(make_pair(q, r));
        }

        string answer;
        if (u <= 2) {
            answer = solve_small(u, queries);
            //answer = solve(u, queries);
        }
        else {
            answer = solve(u, queries);
        }
        cout << "Case #" << tc << ": " << answer << ENDL;
    }

    return 0;
}
