#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <unordered_set>
#include <unordered_map>
#include <queue>
#include <set>
#include <cstdio>
#include <ctime>

using namespace std;
using ll = long long;
struct hash_pair {
    template <class T1, class T2>
    size_t operator()(const pair<T1, T2>& p) const
    {
        auto hash1 = hash<T1>{}(p.first);
        auto hash2 = hash<T2>{}(p.second);
        return hash1 ^ hash2;
    }
};

const int Q_SIZE = 10000;
pair<int, string> Q[Q_SIZE];
int U;
int len(int x) {
    int ans = 0;
    while (x > 0) {
        ans ++;
        x /= 10;
    }
    return ans;
}
int create(int n) {
    int ans = 0;
    while (n--) {
        ans = ans * 10 + 9;
    }
    return ans;
}

int last(int x) {
    while (x > 10) {
        x /= 10;
    }
    return x;
}

bool fits(int digit, char c, int m, string& r) {
    if (r.size() != len(m)) {
        return fits(digit, c, create(r.size()), r);
    }
    int x = 0;
    unordered_map<char, int> tmp;
    int first = 1;
    bool zeroUsed = false;
    for (char rc : r) {
        if (rc == c) {
            x = 10 * x + digit;
        }
        else {
            if (tmp.find(rc) != tmp.end()) {
                x = 10 * x + tmp[c];
            }
            else {
                if (x != 0 && !zeroUsed) {
                    tmp[rc] = 0;
                    x = 10 * x;
                    zeroUsed = true;
                }
                else {
                    tmp[rc] = first;
                    x = 10 * x + first;
                    first++;
                }
            }
        }
    }
    return x <= m;
}

int myPow(int x, int n) {
    int ans = 1;
    while (n--) {
        ans *= x;
    }
    return ans;
}

bool fits(int digit, char c) {
    for (auto p : Q) {
        int m = p.first;
        if (m == -1) {
            m = myPow(10, U) - 1;
        }
        string r = p.second;
        if (!fits(digit, c, m, r)) {
            return false;
        }
    }
    return true;
}

void fix(vector<set<char>>& mapping) {
    vector<bool> used(10, false);
    for (int tries = 0; tries < 10; tries++) {
        for (int i = 0; i < 10; i++) {
            if (!used[i] && mapping[i].size() == 1) {
                char c = *mapping[i].begin();
                for (int j = 0; j < 10; j++) {
                    if (i != j) {
                        mapping[j].erase(c);
                    }
                }
                used[i] = true;
            }
        }
    }
}

string solve() {
    cin >> U;
    set<char> letters;
    for (int i = 0; i < Q_SIZE; i++) {
        int m;
        string s;
        cin >> m >> s;
        Q[i] = { m, s };
        for (char c : s) {
            letters.insert(c);
        }
    }

    vector<set<char>> mapping(10);
    for (int digit = 0; digit < 10; digit++) {
        for (char c : letters) {
            if (fits(digit, c)) {
                mapping[digit].insert(c);
            }
        }
    }
    fix(mapping);
    bool rep = true;
    while (rep) {
        rep = false;
        for (auto& s : mapping) {
            if (s.size() > 1) {
                char c = *s.begin();
                rep = true;
                s.clear();
                s.insert(c);
                break;
            }
        }
        if (rep) {
            fix(mapping);
        }
    }
    string ans = "";
    for (int i = 0; i < 10; i++) {
        ans += *mapping[i].begin();
    }
    return ans;

}

int main() {
    int tests;
    cin >> tests;
    for (int t = 1; t <= tests; t++) {
        cout << "Case #" << t << ": " << solve() << "\n";
    }
    return 0;
}