#include <iostream>
#include <vector>
#include <map>
#include <algorithm>
using namespace std;

typedef long long ll;

const int LINES = 1e4;

vector<int> process(ll num) {
    vector<int> result;

    while(num) {
        result.push_back(num%10);
        num /= 10;
    }
    reverse(result.begin(), result.end());
    return result;
}

int main(){

    int T;
    cin >> T;

    for (int cases = 1; cases <= T; cases++) {
        map<char, int> records;

        int U;
        cin >> U;

        vector<pair<vector<int>, string>> datas;
        int num = LINES;
        while(num--){

            ll n;
            string str;
            cin >> n;
            if (n == -1)
                continue;
            cin >> str;
            auto result = process(n);
            datas.push_back({result, str});
        }

        vector<char> result(10);
        map<char, int> mapping;

        for (int digit = 0; digit < U; digit++){

            for (auto& data : datas){
                auto result = data.first;
                string str = data.second;

                //cout << "process[" << n << "] len=" << result.first << " high=" << result.second << endl;
                if (str.length() == result.size()) {
                    int idx = 0; 
                    pair<char, int> limit{str[idx], result[idx]};
                    
                    while(mapping.find(limit.first) != mapping.end()){
                    //    cout << "!\n";
                        idx++;
                        if (idx == str.length())
                            break;
                        limit.first = str[idx];
                        limit.second = result[idx];
                    }

                    if (idx == str.length())
                        continue;

                    auto it = records.find(limit.first);
                    if (it == records.end()) {
                        records[limit.first] = limit.second;
                    }else {
                        it->second = min(it->second, limit.second);
                    }
               //     cout << str[0] << " " << records[limit.first] << endl; 
                }
            }

            for (auto item : records) {
             //   cout << item.first << " " << item.second << endl;
                result[item.second] = item.first;
                mapping[item.first] = item.second;
            }

        }

        cout << "Case #" << cases << ": ";
        for (int i = 0; i < 10; i++){
            cout << result[i];
        }
        cout << "\n";

    }

    return 0;
}
