#include <cassert>
#include <iostream>
#include <string>

using namespace std;

const int QUERIES = 10000;
const int LETTERS = 26;
const int DIGITS = 10;
int total[LETTERS];
int first[LETTERS];
char dig[DIGITS + 1];

char highest(int *arr) {
    int high = 0, best = 0;
    for (int i = 0; i < LETTERS; i++) {
        if (arr[i] > high) {
            best = i;
            high = arr[i];
        }
    }
    if (high <= 0) {
        assert(1 == 0);
    }
    total[best] = 0;
    first[best] = 0;
    return ('A' + best);
}

char high_total() {
    return highest(total);
}

char high_first() {
    return highest(first);
}

void print() {
    for (int i = 0; i < LETTERS; i++) {
        cout << (char) ('A' + i) << ": " << first[i] << " - " << total[i] << endl;
    }
}

int main() {
    int tt;
    cin >> tt;
    for (int t = 1; t <= tt; t++) {
        int u;
        cin >> u;
        // Benford's law
        for (int i = 0; i < LETTERS; i++) {
            total[i] = 0;
            first[i] = 0;
        }
        for (int i = 0; i < QUERIES; i++) {
            long long q;
            string r;
            cin >> q >> r;
            first[r[0] - 'A']++;
            for (int j = 0; j < r.size(); j++) {
                total[r[j] - 'A']++;
            }
        }
        // print();
        for (int i = 1; i < DIGITS; i++) {
            dig[i] = high_first();
        }
        dig[0] = high_total();

        cout << "Case #" << t << ": " << dig << endl;
    }
    return 0;
}

