#include <bits/stdc++.h>
using namespace std;
constexpr int LINE = 1e4;
constexpr int MAXN = 17;
long long ans[10], p[MAXN];

long long rand(long long x) {
  return ((1LL * rand() << 32) | (1LL * rand())) % x + 1;
}

long long get_num(int len) {
  long long x = p[len + 1] - p[len];
  long long y = rand(x);
  return y + p[len];
}

void solve(long long n, long long sgn) {
  for (int bit = 1; p[bit - 1] <= n; bit++) {
    for (int i = 0; i < 10; i++) {
      long long rem = (n / p[bit - 1]) % 10;
      long long l = n / p[bit];
      long long r = n % p[bit - 1];
      if (i == 0) {
        if (rem) {
          ans[0] += sgn * l * p[bit - 1];
        } else {
          ans[0] += sgn * ((l - 1) * p[bit - 1] + r + 1);
        }
      } else {
        if (i < rem) {
          ans[i] += sgn * (p[bit - 1] * (l + 1));
        } else if (i == rem) {
          ans[i] += sgn * (p[bit - 1] * l + r + 1);
        } else {
          ans[i] += sgn * (p[bit - 1] * l);
        }
      }
    }
  }
}

int main() {
  int T, kase = 1;
  scanf("%d", &T);
  p[0] = 1;
  for (int i = 1; i < MAXN; i++) {
    p[i] = p[i - 1] * 10;
  }
  while (T--) {
    int u;
    scanf("%d", &u);
    map<char, int> cnt;
    map<int, long long> freq;
    for (int i = 0; i < LINE; i++) {
      long long num;
      string s;
      cin >> num >> s;
      if (num == -1) {
        num = get_num(s.size());
      }
      long long l = p[s.size() - 1], r = min(p[s.size()] - 1, num);
      memset(ans, 0, sizeof(ans));
      solve(r, 1);
      solve(l - 1, -1);
      for (int j = 0; j < 10; j++) {
        freq[j] += ans[j];
      }
      for (auto c : s) {
        cnt[c]++;
      }
    }
    vector<pair<char, int>> vec(cnt.begin(), cnt.end());
    vector<pair<int, long long>> f(freq.begin(), freq.end());
    sort(vec.begin(), vec.end(),
         [](const pair<char, int> &a, const pair<char, int> &b) {
           if (a.second != b.second) {
             return a.second < b.second;
           } else {
             return a.first < b.first;
           }
         });
    sort(f.begin(), f.end(),
         [](const pair<int, long long> &a, const pair<int, long long> &b) {
           if (a.second != b.second) {
             return a.second < b.second;
           } else {
             return a.first < b.first;
           }
         });
    string ans(10, 'A');
    for (int i = 0; i < 10; i++) {
      ans[f[i].first] = vec[i].first;
    }
    printf("Case #%d: %s\n", kase++, ans.c_str());
  }
  return 0;
}

