#include <iostream>
#include <fstream>
#include <string>
#include <set>
#include <algorithm>
#include <vector>
#include <memory>
#include <map>

using namespace std;
const int rows = 10000;

struct comp
{
	template<typename T>
	bool operator()(const T& l, const T& r) const
	{
		if (l.second != r.second)
			return l.second < r.second;

		return l.first < r.first;
	}
};

string solve(int U, int Q[], string R[]) {
	map<char, int> lte;
	set<char> notZero;
	set<int> unknown;
	for (int i = 0; i < 10; i++) {
		unknown.insert(i);
	}
	for (int i = 0; i < rows; i++) {
		int Qi = Q[i];
		string Ri = R[i];
		notZero.insert(Ri[0]);
		for (int j = 0; j < Ri.length(); j++) {
			auto search = lte.find(Ri[j]);
			if (search == lte.end())
				lte[Ri[j]] = 0;
			lte[Ri[j]]++;
		}
	}
	char zero;
	for (auto it = lte.begin(); it != lte.end(); ++it) {
		if (notZero.find(it->first) == notZero.end())
			zero = it->first;
	}
	lte.erase(zero);
	set<pair<char, int>, comp> dst(lte.begin(), lte.end());
	string result = "";
	for (auto it = dst.begin(); it != dst.end(); ++it) {
		result = it->first + result;
	}
	result = zero + result;
	return result;
}

int main()
{
	int T;
	cin >> T;
	for (int t = 0; t < T; t++) {
		cout << "Case #" << t + 1 << ": ";
		int U;
		int Q[rows];
		string R[rows];
		cin >> U;
		for (int i = 0; i < rows; i++) {
			cin >> Q[i] >> R[i];
		}
		cout << solve(U, Q, R) << endl;
	}
	return 0;
}
