#include <iostream> // includes cin to read from stdin and cout to write to stdout
#include <vector>
#include <algorithm>

using namespace std; // since cin and cout are both in namespace std, this saves some text

bool cmpPairs(const pair<int, int>& a, const pair<int, int>& b) { 
    return (a.first > b.first); 
}

int main() {
    int t;
    cin >> t;
    for (int i = 1; i <= t; ++i) {
        int U;
        cin >> U;
        vector<pair<int, int> > counts;
        int seen[26];
        for (auto & b : seen) {
            b = -1;
        }
        for (size_t i = 0; i < 26; ++i) {
            counts.push_back(make_pair(0, i));
        }
        for (size_t i = 0; i < 10000; ++i) {
            string Qi, Ri;
            cin >> Qi >> Ri;
            seen[Ri[0] - 'A'] = 0; // can't be zero
            for (size_t i = 1; i < Ri.length(); ++i) {
                if (seen[Ri[i] - 'A'] != 0) {
                    seen[Ri[i] - 'A'] = 1; // can be zero
                }
            }
            ++counts[Ri[0] - 'A'].first;
        }
        // find zero
        string res;
        for (size_t i = 0; i < 26; ++i) {
            if (seen[i] == 1) {
                res += char('A' + i);
                counts[i].first = 0;
                break;
            }
        }
        sort(counts.begin(), counts.end(), &cmpPairs);
        for (size_t i = 0; i < 9; ++i) {
            res += char('A' + counts[i].second);
        }
        cout << "Case #" << i << ": " << res << endl;
    }
    return 0;
}