#include <algorithm>
#include <array>
#include <iostream>
#include <set>
#include <vector>

using namespace std;

int64_t upper_digit(int64_t m)
{
    int64_t ans = 0;
    while (m > 0)
    {
        ans = m % 10;
        m /= 10;
    }
    return ans;
}

int64_t powi(int64_t base, int64_t index)
{
    int64_t ans = 1;
    for (int i = 0; i < index; i++)
    {
        ans *= base;
    }
    return ans;
}

int main()
{
    int T;
    cin >> T;
    for (int t = 1; t <= T; t++)
    {
        int64_t u;
        cin >> u;
        const auto base = powi(10, u - 1);

        array<int64_t, 256> table = {};
        array<int64_t, 256> all_table = {};
        array<set<char>, 10> cand_table = {};

        for (int i = 0; i < 10000; i++)
        {
            int64_t m;
            string s;
            cin >> m >> s;

            if (s.size() == u)
            {
                table[s[0]]++;

                const int64_t ud = upper_digit(m);
                for (int j = ud; j <= 9; j++)
                {
                    cand_table[j].insert(s[0]);
                }
            }
            for (auto ch : s)
            {
                all_table[ch]++;
            }
        }
        cout << "Case #" << t << ": ";

        {
            set<char> zeros;
            for (char ch = 'A'; ch <= 'Z'; ch++)
            {
                if (all_table[ch] > 0)
                {
                    zeros.insert(ch);
                }
            }
            for (char ch : zeros)
            {
                if (cand_table[9].find(ch) == cand_table[9].end())
                {
                    cout << ch;
                }
            }
        }

        for (int i = 1; i <= 9; i++)
        {
            for (auto ch : cand_table[i])
            {
                if (cand_table[i - 1].find(ch) == cand_table[i - 1].end())
                {
                    cout << ch;
                }
            }
        }
        cout << endl;
    }

    return 0;
}