#include<cstdio>
#include<algorithm>
#include<vector>
using namespace std;
#define N_ 101000
#define SZ 131072
#define pli pair<long long,int>
struct Edge{
    int e, c, f;
};
vector<Edge>E[N_];
vector<int>G[N_];
int n, par[N_], P[N_], C[N_], Num[N_], cnt, PPP[N_], ord[N_];
long long D[N_];
int INF = 1e9;
struct Tree{
    int Mn[SZ+SZ], K[SZ+SZ];
    void UDT(int nd){
        Mn[nd]=min(Mn[nd*2],Mn[nd*2+1]);
    }
    void init(int nd, int b, int e){
        Mn[nd]=K[nd]=0;
        if(b==e){
            Mn[nd] = P[ord[b]];
            return;
        }
        int m = (b+e)>>1;
        init(nd*2,b,m);
        init(nd*2+1,m+1,e);
        UDT(nd);
    }
    void Add2(int nd, int x){
        Mn[nd]+=x;
        K[nd]+=x;
    }
    void Spread(int nd){
        Add2(nd*2,K[nd]);
        Add2(nd*2+1,K[nd]);
        K[nd]=0;
    }
    void Add(int nd, int b, int e, int s, int l, int x){
        if(s>l)return;
        if(s<=b&&e<=l){
            Add2(nd,x);
            return;
        }
        Spread(nd);
        int m = (b+e)>>1;
        if(s<=m)Add(nd*2,b,m,s,l,x);
        if(l>m)Add(nd*2+1,m+1,e,s,l,x);
        UDT(nd);
    }
    int Get(int nd, int b, int e, int s, int l){
        if(s>l)return INF;
        if(s<=b&&e<=l)return Mn[nd];
        Spread(nd);
        int m = (b+e)>>1, r1=INF,r2=INF;
        if(s<=m)r1=Get(nd*2,b,m,s,l);
        if(l>m)r2=Get(nd*2+1,m+1,e,s,l);
        return min(r1,r2);
    }
}T;
void DFS(int a, long long s){
    D[a] = s;
    C[a]=1;
    for(auto &t : E[a]){
        P[t.e] = t.f;
        par[t.e] = a;
        DFS(t.e, s+t.c);
        C[a]+=C[t.e];
    }
}
void HLD(int a, int ppp){
    int Mx=-1,pv=-1;
    PPP[a]=ppp;
    Num[a]=++cnt;
    ord[cnt] = a;
    for(auto &x : G[a]){
        if(Mx<C[x]){
            Mx=C[x];
            pv=x;
        }
    }
    if(pv!=-1){
        HLD(pv,ppp);
    }
    for(auto &x : G[a]){
        if(x==pv)continue;
        HLD(x,x);
    }
}
int Calc(int a){
    int r = INF;
    while(1){
        if(PPP[a]==PPP[1]){
            r = min(r, T.Get(1, 1, n, 2, Num[a]));
            break;
        }
        r = min(r, T.Get(1, 1, n, Num[PPP[a]], Num[a]));
        a=par[PPP[a]];
    }
    return r;
}
void Del(int a, int d){
    while(1){
        if(PPP[a]==PPP[1]){
            T.Add(1, 1, n, 2, Num[a], -d);
            break;
        }
        T.Add(1, 1, n, Num[PPP[a]], Num[a], -d);
        a=par[PPP[a]];
    }
}
void Solve(){
    int i;
    scanf("%d",&n);
    for(i=1;i<=n;i++){
        E[i].clear();
        G[i].clear();
    }
    for(i=1;i<n;i++){
        int a,b,c,d;
        scanf("%d%d%d%d",&a,&b,&c,&d);
        E[a].push_back({b,d,c});
        G[a].push_back(b);
    }
    DFS(1,0);
    cnt = 0;
    HLD(1,1);
    vector<pli>V;
    for(i=2;i<=n;i++){
        V.push_back({D[i],i});
    }
    sort(V.begin(),V.end());
    long long r1 = 0, r2 =0;
    T.init(1,1,n);
    for(auto &t : V){
        int a = t.second, c = 1e9;
        int d = Calc(a);
        if(d){
            Del(a,d);
            r1+=d;
            r2+=d*D[a];
        }
    }
    printf("%lld %lld\n",r1,r2);
}
int main(){
    int TC, T;
    scanf("%d",&TC);
    for(T=1;T<=TC;T++){
        printf("Case #%d: ",T);
        Solve();
    }
}