#include <bits/stdc++.h>
using namespace std;
typedef long long ll;

const int nax = 1e5+10;
vector<int> node[nax];
vector<array<int,2>> edge[nax];


int par[nax], depth[nax], maxdepth[nax];

void dfs(int p, int parent = -1, int d = 0) {
  depth[p] = d;
  par[p] = parent;
  maxdepth[p] = d;
  for (int i : node[p]) {
    if (i == parent) continue;
    dfs(i, p, d+1);
    maxdepth[p] = max(maxdepth[p], maxdepth[i]);
  }
}

ll pathcost[nax], pathcap[nax];
void dfs2(int p, ll sum = 0) {
  pathcost[p] = sum;
  for (int ei = 0; ei < (int)node[p].size(); ei++) {
    pathcap[node[p][ei]] = edge[p][ei][0];
    dfs2(node[p][ei], sum+edge[p][ei][1]);
  }
}


struct SlowTree {
  ll data[nax];
  void init() {}
  void add(int i, int v) {
    for (int p = i; p != -1; p = par[p])
      data[p] += v;
  }
  ll query(int i) {
    ll r = 1e9;
    for (int p = i; p != -1; p = par[p])
      r = min(r, data[p]);
    return r;
  }
};





struct SegTree {
  vector<ll> mi, off;
  int n;
  SegTree(int n_) {
    n = 1;
    while (n < n_+5) n *= 2;
    mi.resize(n*2);
    off.resize(n*2);
  }
  void add(int r, ll v) {
    r++;
    for (int i = r+n; i > 1; i >>= 1) {
      if (i&1) {
	off[i-1] += v;
      }
      mi[i>>1] = min(mi[i]+off[i], mi[i^1]+off[i^1]);
    }
  }
  ll query(int r) {
    r++;
    ll ret = 1e9;
    for (int i = r+n; i > 1; i >>= 1) {
      if (i&1) {
	ret = min(ret, mi[i-1]+off[i-1]);
      }
      ret += off[i>>1];
    }
    return ret;
  }
};


struct FastTree {
  int treei[nax], treep[nax];
  vector<SegTree> tree;
  vector<int> hpar;
  void hld(int p, int par, int treei_, int treep_) {
    if (treei_ == -1) {
      treei_ = tree.size();
      treep_ = 0;
      tree.push_back(SegTree(maxdepth[p]-depth[p]+1));
      hpar.push_back(par);
    }
    treei[p] = treei_;
    treep[p] = treep_;

    int heavy = -1, d = -1;
    for (int i : node[p]) {
      if (i == par) continue;
      if (maxdepth[i] > d) {
	heavy = i;
	d = maxdepth[i];
      }
    }
    if (heavy != -1)
      hld(heavy, p, treei_, treep_+1);

    for (int i : node[p]) {
      if (i == par || i == heavy) continue;
      hld(i, p, -1, -1);
    }
  }
  void init() {
    hld(0, -1, -1, -1);
  }
  void add(int i, ll v) {
    for (; i != -1; i = hpar[treei[i]]) {
      tree[treei[i]].add(treep[i], v);
    }
  }
  ll query(int i) {
    ll r = 1e9;
    for (; i != -1; i = hpar[treei[i]]) {
      r = min(r, tree[treei[i]].query(treep[i]));
    }
    return r;
  }
};


int main() {
  ios::sync_with_stdio(0); cin.tie(0);
  int t;
  cin >> t;
  int cc = 1;
  while (t--) {
    cout << "Case #" << cc++ << ": ";
    int n;
    cin >> n;
    for (int i = 0; i < n; i++) node[i].clear(), edge[i].clear();

    for (int i = 1; i < n; i++) {
      int a, b, cap, cost;
      cin >> a >> b >> cap >> cost;
      a--, b--;
      node[a].push_back(b);
      edge[a].push_back({cap,cost});
    }
    dfs(0);
    dfs2(0);

    FastTree tree;
    tree.init();
    tree.add(0, 1e9);

    vector<pair<ll,int>> order;
    for (int i = 1; i < n; i++) {
      order.emplace_back(pathcost[i], i);
      tree.add(i, pathcap[i]);
      tree.add(par[i], -pathcap[i]);
    }
    sort(order.begin(), order.end());

    ll sumcap = 0, sumcost = 0;
    for (auto cp : order) {
      ll cost = cp.first, p = cp.second;
      ll take = tree.query(p);
      sumcap += take;
      sumcost += cost*take;
      tree.add(p, -take);
    }
    cout << sumcap << ' ' << sumcost << endl;
  }
}
