#include <bits/stdc++.h>
#define sz(v) ((int)(v).size())
#define all(v) (v).begin(), (v).end()
using namespace std;
typedef long long lint;
typedef long double llf;
typedef pair<lint, lint> pi;
const int MAXN = 100005;

struct edg{
	int pos, cap, cst;
};

int n;
vector<edg> gph[MAXN];
vector<int> dfn;
lint depth[MAXN], pae[MAXN];

void dfs(int x){
	dfn.push_back(x);
	for(auto &i : gph[x]){
		depth[i.pos] = depth[x] + i.cst;
		pae[i.pos] = i.cap;
		dfs(i.pos);
	}
}

int idx[MAXN];
lint sum[MAXN];
priority_queue<pi> pq[MAXN]; // (cost, ppl)

void solve(){
	reverse(all(dfn));
	iota(idx, idx + n + 1, 0);
	for(auto &v : dfn){
		for(auto &ww : gph[v]){
			int w = ww.pos;
			if(sz(pq[idx[v]]) < sz(pq[idx[w]])){
				swap(idx[v], idx[w]);
			}
			while(sz(pq[idx[w]])){
				auto x = pq[idx[w]].top(); pq[idx[w]].pop();
				pq[idx[v]].push(x);
				sum[idx[v]] += x.second;
			}
		}
		if(v != 1){
			pq[idx[v]].emplace(depth[v], 1e5);
			sum[idx[v]] += 1e5;
			while(sum[idx[v]] > pae[v]){
				auto x = pq[idx[v]].top();
				pq[idx[v]].pop();
				lint delta = min(x.second, sum[idx[v]] - pae[v]);
				x.second -= delta;
				sum[idx[v]] -= delta;
				if(x.second){
					pq[idx[v]].push(x);
					break;
				}
			}
		}
	}
	lint ret = 0;
	while(sz(pq[idx[1]])){
		auto x = pq[idx[1]].top();
		pq[idx[1]].pop();
		ret += x.second * x.first;
	}
	printf("%lld %lld\n", sum[idx[1]], ret);
}

void init(){
	dfn.clear();
	for(int i=0; i<MAXN; i++) gph[i].clear();
	for(int i=0; i<MAXN; i++){
		while(sz(pq[i])){
			pq[i].pop();
		}
		sum[i] = 0;
	}
}

int main(){
	int t; scanf("%d",&t);
	for(int i=1; i<=t; i++){
		printf("Case #%d: ", i);
		init();
		scanf("%d",&n);
		for(int i=0; i<n-1; i++){
			int u, v, x, y; 
			scanf("%d %d %d %d",&u,&v,&x,&y);
			gph[u].push_back({v, x, y});
		}
		dfs(1);
		solve();
	}
}
