#include <iostream>
 #include <algorithm>
 #include <vector>
 #include <math.h>
 #include <cstdio>
 
 using namespace std;
 
 vector<pair<int, int> > v;
 int D;
 
 long double dist(int start, int end, int numV, long double avrg) {
 	long double left = avrg - (numV%2 == 0 ? D/2.0 : 0) - D*int((numV-1)/2), right;
 	long double res = 0;
 	for (int i=start; i < end; i++) {	
 		right = left + v[i].second*D - D;
 		res = max(res, v[i].first - left);
 		res = max(res, right - v[i].first);
 		left = right+D;
 	}
 	return res;
 }
 
 long double ternSearch(int start, int end, int numV) {
 	long double l = -1e6;
 	long double r = 1e6;
 	while (r-l >= 1e-7) {
 		long double l3 = (2*l + r)/3.0;
 		long double r3 = (l + 2*r)/3.0;
 		
 		if (dist(start, end, numV, l3) > dist(start, end, numV, r3)) {
 			l = l3;
 		} else {
 			r = r3;
 		}
 	}
 	return dist(start, end, numV, (l+r)/2.0);
 }
 
 int main() {
 	int T; cin >> T;
 	for (int count = 1; count <= T; count ++) {
 		int C;
 
 		cin >> C >> D;
 		v.clear();
 		for (int i=0; i < C; i++) {
 			int P, V;
 			cin >> P >> V;
 			v.push_back(make_pair(P,V));
 		}
 		
 		int start = 0;
 		long double mx = v[0].first - (v[0].second % 2 == 0 ? D/2.0 : 0) + D*int(v[0].second/2);
 		long double time = mx*1.0-v[0].first;
 		for (int i=1; i <= C; i++) {
 			if (i < C && v[i].first - (v[i].second % 2 == 0 ? D/2.0 : 0) - D*int(v[i].second/2) < mx) {
 				continue;
 			}
 			int numV = 0;
 			for (int j=start; j<i; j++) numV += v[j].second;
 			time = max(time, ternSearch(start, i, numV));
 			start = i;
 		}
 		double res = time;
 		printf("Case #%d: %.7f\n", count, res);
 	}
 }