/*
 problem b, google code jam 2011
 coded by Jason Thong
 jason.thong.86@gmail.com
 
 merge neighbors who interact, merged result goes in the halfway point with sum of vendors
 */
 
 #include <stdio.h>
 #include <stdlib.h>
 #include <math.h>
 
 #define ABS(a) (((a) < 0) ? -(a) : (a))
 #define MAX_C 200
 
 int main(int argc, char **argv) {
 	int test_cases, i, j, k, n, m, C, D, V[MAX_C], V_orig[MAX_C], j_find, j_find_next;
 	double P[MAX_C], P_orig[MAX_C], left_spreading_towards_right, right_spreading_towards_left, left_bound, right_bound, worst_time, this_time;
 	char no_more_merges;
 	FILE *fp_in, *fp_out;
 	
 	if (argc!=3) {
 		printf("provide input and output file names as first 2 command line parameters\n");
 		exit(1);
 	}
 	if ((fp_in=fopen(argv[1],"r"))==NULL) { printf("can't open file %s\n", argv[1]); exit(1); }
 	if ((fp_out=fopen(argv[2],"w"))==NULL) { printf("can't open file %s\n", argv[2]); exit(1); }
 	fscanf(fp_in, "%d\n", &test_cases);
 	
 	for (i=1; i<=test_cases; i++) {
 //		printf("i %d\n", i);
 		fscanf(fp_in, "%d %d\n", &C, &D);
 		for (j=0; j<C; j++) {
 			fscanf(fp_in, "%d %d\n", &k, &(V[j]));
 			P[j] = k;
 		}
 		for (j=0; j<C; j++) {
 			P_orig[j] = P[j];
 			V_orig[j] = V[j];
 		}
 		/*
 		if (i==27) {
 			printf("C %d, D %d\n", C, D);
 			for (j=0; j<C; j++) printf("%lf %d\n", P[j], V[j]);
 			
 		}
 		*/
 		do {
 			no_more_merges = 1;
 			j = 0;
 			j_find = j+1;
 			while (j_find<C && V[j_find]==0) j_find++;
 			j_find_next = j_find+1;
 			while (j_find_next<C && V[j_find_next]==0) j_find_next++;
 			while (j_find < C) {	//compare index j and j_find
 				left_spreading_towards_right = P[j] + (V[j]-1)*D*0.5;
 				right_spreading_towards_left = P[j_find] - (V[j_find]-1)*D*0.5;
 				if (left_spreading_towards_right + D > right_spreading_towards_left) {	//they interact, merge them
 			//	if (i==43) printf("merging %d %d\n", j, j_find);
 				//	P[j] = (P[j] + P[j_find]) * 0.5;	//midpoint
 					P[j] = 0;
 					for (k=j; k<j_find_next; k++) P[j] += P_orig[k];	//midpoint (avg) or original positions
 					P[j] /= (j_find_next-j);
 					V[j] += V[j_find];	//sum
 					no_more_merges = 0;
 					V[j_find] = 0;	//put hole in list
 					break;
 				}
 				j = j_find;
 				j_find = j_find_next;
 				j_find_next = j_find+1;
 				while (j_find_next<C && V[j_find_next]==0) j_find_next++;
 			}
 		} while (no_more_merges==0);
 		//at this point, no groups interact with each other
 		worst_time = 0;
 		for (j=0; j<C; j++) {
 			if (V[j]!=0) {	//merged group, leftmost
 				j_find = j;
 				left_bound = P[j] - (V[j]-1)*D*0.5;
 				right_bound = left_bound + (V_orig[j]-1)*D;
 //				if (i==43) printf("new left bound %lf, right bound %lf, j %d\n", left_bound, right_bound, j);
 			}
 			else {	//not leftmost, pick up next adjacent section
 				left_bound = right_bound + D;
 				right_bound = left_bound + (V_orig[j]-1)*D;
 				if (j+1<C && V[j+1]!=0) {
 					right_spreading_towards_left = P[j_find] + (V[j_find]-1)*D*0.5;
 					if (right_bound != right_spreading_towards_left) printf("error %lf %lf, %d %d\n", right_bound, right_spreading_towards_left, i, j);
 				}
 //				if (i==43) printf("existing new left bound %lf, right bound %lf, j %d\n", left_bound, right_bound, j);
 			}
 			//else bounds are same as previous, merging always puts result in lower index
 			this_time = ABS(P_orig[j] - left_bound);
 //			printf("left %lf P orig[%d] %lf\n", this_time, j, P_orig[j]);
 			if (this_time > worst_time) worst_time = this_time;
 			this_time = ABS(right_bound - P_orig[j]);
 //			printf("right %lf\n", this_time);
 			if (this_time > worst_time) worst_time = this_time;
 		}
 		fprintf(fp_out, "Case #%d: %lf\n", i, worst_time);
 	}
 	
 	fclose(fp_in);
 	fclose(fp_out);
 	return 0;
 }
 
 
 
