#include <iostream>
 #include <vector>
 #include <algorithm>
 #include <string>
 #include <map>
 #include <list>
 #include <cmath>
 #include <cstdlib>
 #include <queue>
 #include <stack>
 using namespace std;
 
 struct vendor {
   long long pos, num;
 };
 
 bool compare(const vendor& a, const vendor& b)
 {
   return a.pos < b.pos;
 }
 
 long double myAbs(long double num) {
   if (num < 0)
     return -num;
   return num;
 }
 
 int main()
 {
   int T;
   cin >> T;
   for (int t = 1; t <= T; t++) {
     long long D, C;
     cin >> C >> D;
     vector<vendor> info;
     long long total = 0;
     for (long long i = 0; i < C; i++) {
       vendor element;
       long long P, V;
       cin >> P >> V;
       element.pos = P;
       element.num = V;
       total += V;
       info.push_back(element);
     }
     sort(info.begin(), info.end(), compare);
 
     long double minT = 1e32;
     for (long long i = 0; 
 	 i <= (D * total - (info[C - 1].pos - info[0].pos)) * 2;
 	 i++) {
       long double start = info[0].pos - i * 0.5;
       long double time = 0;
       long long pos = 0;
       for (long long j = 0; j < C; j++) 
 	for (long long k = 0; k < info[j].num; k++) {
 	  long double current = myAbs(start + D * pos - info[j].pos);
 	  if (current > time)
 	    time = current;
 	  pos++;
 	}
       if (time < minT)
 	minT = time;
     }
     cout << "Case #" << t << ": ";
     cout << minT << endl;
   }
   return 0;
 }
