#include <cstdio>
 #include <algorithm>
 #include <iostream>
 
 using namespace std;
 
 const int nmax = 205;
 
 struct Position {
   int p;
   int n;
 
   bool operator<(const Position& ob) const {
     return p < ob.p;
   }
 } pos[nmax];
 int npos;
 
 int d;
 
 double minR(int num) {
   return (num - 1.0) * d;
 
 }
 
 double minTime(double init_dist, double target_dist) {
   return (target_dist - init_dist) / 2.0;
 }
 
 
 
 int main(void) {
   int nc;
 
   freopen("B-small-attempt0.in", "r", stdin);
   freopen("B.small.out", "w", stdout);
 
   scanf("%d", &nc);
 
 
   for (int c = 1; c <= nc; c++) {
     scanf("%d %d", &npos, &d);
 
     for (int i = 0; i < npos; ++i) {
       scanf("%d %d", &pos[i].p, &pos[i].n);
     }
 
     sort(pos, pos + npos);
 
     pos[npos].p = 1e10;
     pos[npos].n = 0;
     npos++;
 
     double md = 0.0;
     double rm_pos = -1e10;
 
 
     for (int i = 0; i < npos; ++i) {
       double num = 0;
       double pos_start = pos[i].p;
       double pos_end = pos_start;
       for (int j = i; j < npos; ++j) {
         pos_end = pos[j].p;
         num = num + pos[j].n;
 
         double dist = pos_end - pos_start;
         double min_dist = minR(num);
         double r_pos = pos_end, l_pos = pos_start;
         if (dist < min_dist) {
           min_dist = minR(num);
           dist = pos_end - pos_start;
           double mt = minTime(dist, min_dist);
           
 
           l_pos = pos_start - mt;
           r_pos = pos_end + mt;
 
           if (l_pos < rm_pos) {
             mt += (rm_pos - l_pos);
           }
 
           md = max(mt, md);
         } else {
           rm_pos = r_pos;
           i = j;
           break;
         }
       }
     }
 
     printf("Case #%d: %f\n", c, md);
 
   }
 
 }