#include <vector>
 #include <list>
 #include <map>
 #include <string>
 #include <iostream>
 #include <iomanip>
 #include <sstream>
 #include <algorithm>
 #include <cmath>
 #include <cstdlib>
 
 using namespace std;
 
 typedef unsigned long long huge;
 #define abserr(n) setprecision(n) << fixed << showpoint
 string getline();
 template <typename T>
 inline T get(istream &is = cin);
 
 typedef struct {
 	int V, P;
 } point;
 
 double getTime(const vector<point> &points, double leftMost, huge D){
 	double maxDist = 0;
 	double cP = leftMost;
 	for(int c=0; c<points.size(); c++){
 		for(int v=0; v<points[c].V; v++){
 			double cD = cP - (double)points[c].P;
 			if(cD < 0) cD = -cD;
 			if(cD > maxDist)
 				maxDist = cD;
 			cP += D;
 		}
 	}
 	return maxDist;
 }
 
 void solveCase(){
 	huge C, D;
 	cin >> C >> D;
 	
 	vector<point> points(C);
 	int Vt=0;
 	int Pmin, Pmax;
 	for(int c=0; c<C; c++){
 		cin >> points[c].P >> points[c].V;
 		Vt += points[c].V;
 		if(c==0)   Pmin = points[c].P;
 		if(c==C-1) Pmax = points[c].P;
 	}
 	
 	double leftMost = 0;
 	double maxDP=-1e10, maxDN=1e10;
 	double cP = leftMost;
 	for(int c=0; c<C; c++){
 		for(int v=0; v<points[c].V; v++){
 			double cD = cP - (double)points[c].P;
 			if(cD > maxDP) maxDP = cD;
 			if(cD < maxDN) maxDN = cD;
 			cP += D;
 		}
 	}
 	
 	cerr << C << " " << D << " -> " << maxDP << " " << maxDN << endl;
 	
 	cout << abserr(7) << getTime(points, -(maxDP+maxDN)/2, D) << endl;
 }
 
 int main(int argc, char *argv[]){
 	stringstream line(getline());
 	unsigned int T;
 	
 	line >> T;
 	
 	for(unsigned int t=1; t<=T; t++){
 		cout << "Case #" << t << ": ";
 		cerr << "Case #" << t << endl;
 		solveCase();
 	}
 	
 	return 0;
 }
 string getline(){
 	string tmp;
 	getline(cin, tmp);
 	return tmp;
 }
 template <typename T>
 inline T get(istream &is){
 	T tmp;
 	is >> tmp;
 	return tmp;
 }
 
