#include <iostream>
 #include <algorithm>
 #include <string>
 #include <cstdio>
 #include <cmath>
 
 using namespace std;
 
 long long P[200]; // position of vendors in increasing order
 long long V[200]; // count of vendors
 
 int main()
 {
 	//freopen("test.txt","r",stdin);freopen("test.out","w",stdout);
 	freopen("B-small.in","r",stdin);freopen("B-small.out","w",stdout);
 	//freopen("B-large.in","r",stdin);freopen("B-large.out","w",stdout);
 	int testcase;
 	cin >> testcase;
 	for (int caseId=1;caseId<=testcase;caseId++)
 	{
 		long long C, D;
     cin >> C >> D;
     long long total = 0;
     for(int i=0; i!=C; i++) {
       cin >> P[i] >> V[i];
       total += V[i];
     }
 
     int i=0;
     int j=C-1;
     double tspan = (total-1.0)*D; // objective span
     double ospan = (P[j]-P[i]); // original span
     while(tspan < ospan && j>=i) { // already very wide
       if(P[i+1]-P[i] > P[j]-P[j-1]) { // we can keep the left most vendor
         V[i] --;
         if(V[i]==0) {
           i++;
         }
       }
       else { // we can keep the right most vendor
         V[j] --;
         if(V[j]==0) {
           j--;
         }
       }
       total--;
       tspan = (total-1.0)*D;
       ospan = P[j]-P[i];
     }
     // now we have tspan >= ospan
     double Emin = P[i]-(tspan-ospan)/2; // smallest empty grid position
     double Emax = P[j]+(tspan-ospan)/2; // largest empty grid position
 
     double maxt = 0;
     long long left = total; 
     double tl;
     double tr;
     while(left > 1 && j>=i) {
       // dispatch left-most vendor to left-most empty spot
       tl = P[i]-Emin;
       // dispatch right-most vendor to right-most empty spot
       tr = Emax-P[j];
       if(tl > maxt)
         maxt = tl;
       if(tr > maxt)
         maxt = tr;
 
       // update loop invarients
       Emin += D;
       Emax -= D;
       V[i] --;
       V[j] --;
       left -= 2;
       if(V[i]==0)
         i++;
       if(V[j]==0)
         j--;
     } 
     // dispatch the last one if exits
     if(left == 1) {
       tl = fabs(P[i]-Emin);
       if(tl > maxt)
         maxt = tl;
       left --;
     }
     printf("Case #%d: ",caseId);
     printf("%lf\n", maxt);
 	}
 
 	return 0;
 }
