#include <algorithm>
 #include <cmath>
 #include <cstdio>
 #include <cstdlib>
 #include <cstring>
 #include <iostream>
 #include <map>
 #include <sstream>
 #include <string>
 #include <fstream>
 #include <vector>
 using namespace std;
 int TESTS;
 vector<pair<long long,long long> > vendors;
 long long C,P,V;
 double D;
 double tot_dist;
 
 bool solve(double seconds){
 	for(double point = vendors[0].first - tot_dist; point <= vendors[0].first; point+= 0.5){
 		double pointNow = point;
 		bool valid = true;
 		for(int i = 0; i<vendors.size(); i++){
 			for(int j = 0; j<vendors[i].second; j++){
 				if(abs(vendors[i].first - pointNow) > seconds) {valid = false;break;}
 				else pointNow += D;
 			}
 		}
 		if(valid) return true;
 	}
 	return false;
 }
 
 double binarySearch(double low, double high){
 	double mid;
 	for(int i = 0; i<100; i++){
 		mid = low + (high-low)/2;
 		if(solve(mid)) high = mid;
 		else low = mid;
 	}
 	/*double tmp = (int)low;
 	if(abs(low - tmp) < 0.1) low = tmp;
 	tmp += 0.5;
 	if(abs(low - tmp) < 0.1) low = tmp;
 	tmp += 0.5;
 	if(abs(low - tmp) < 0.1) low = tmp;*/
 	return low;         // low is the least x for which solve(x) is true
 }
 
 int main(){
 	ifstream in("Input.in");
 	ofstream out("Output.out");
 	in >> TESTS;
 	for(int test = 1; test<=TESTS; test++){
 		cout << "solving case " << test << endl;
 		vendors.clear();
 		in >> C >> D;
 		tot_dist = 0;
 		for(int i = 0; i<C; i++){
 			in >> P >> V;
 			tot_dist += V*D;
 			vendors.push_back(make_pair(P,V));
 		}
 		sort(vendors.begin(), vendors.end());
 		double ret = 0;
 		if(vendors.size() == 1) ret = 0;
 		else if(vendors[0].first == vendors[vendors.size()-1].first)
 			ret = ((V-1)/2)*D + D/2; 
 		else
 			ret = binarySearch(0, V*D*C);
 		out << "Case #" << test << ": " << ret <<  endl;
 	}
 } 
 
